/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public interface IKeyedObjectIndex<T> {
    public Set<String> getAllIds() throws StorageException;

    public IKeyedObjectDescriber<T> getDescriber();

    public T getById(String var1) throws StorageException;

    default public List<T> getByIds(Collection<String> ids) throws StorageException {
        ArrayList<T> result = new ArrayList<T>(ids.size());
        for (String id : ids) {
            result.add(this.getById(id));
        }
        return result;
    }

    public List<TimedShallowObjectState> query(List<String> var1, PairList<String, String> var2) throws StorageException;

    default public Collection<String> getAlwaysQueryColumns() {
        return Collections.emptyList();
    }

    public List<TimedShallowObjectState> query(List<String> var1, PairList<String, String> var2, long var3) throws StorageException;

    public PairList<String, EKeyedObjectType> getKnownColumns() throws StorageException;

    public EKeyedObjectType getColumnType(String var1) throws StorageException;

    public static EKeyedObjectType getColumnType(String columnName, PairList<String, EKeyedObjectType> columns) {
        Optional columnIndex = columns.indexOfFirst((Object)columnName);
        if (columnIndex.isPresent()) {
            return (EKeyedObjectType)((Object)columns.getSecond(((Integer)columnIndex.get()).intValue()));
        }
        return EKeyedObjectType.STRING;
    }

    public List<String> getKnownValues(String var1) throws StorageException;
}

