/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.engine.DelegatingCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;

public class AttributeCheckingDescriberCompilationContext<T>
extends DelegatingCompilationContext<T> {
    private final Set<String> knownAttributes;

    public AttributeCheckingDescriberCompilationContext(ICompilationContext<T> delegate, Collection<String> knownAttributes) {
        super(delegate);
        this.knownAttributes = new HashSet<String>(knownAttributes);
    }

    @Override
    public EKeyedObjectType getAttributeType(String attribute) throws QueryCompilationException {
        this.checkAttributeExists(attribute);
        return super.getAttributeType(attribute);
    }

    @Override
    public Function<T, String> getAttributeAccessor(String attribute) throws QueryCompilationException {
        this.checkAttributeExists(attribute);
        return super.getAttributeAccessor(attribute);
    }

    @Override
    public Predicate<T> getAttributeEqualsIgnoreCasePredicate(String attribute, String comparisonValue, boolean lenient) throws QueryCompilationException {
        this.checkAttributeExists(attribute);
        return super.getAttributeEqualsIgnoreCasePredicate(attribute, comparisonValue, lenient);
    }

    private void checkAttributeExists(String attribute) throws QueryCompilationException {
        if (!this.knownAttributes.contains(attribute)) {
            throw new QueryCompilationException("Attribute '%s' does not exist!".formatted(attribute), attribute);
        }
    }
}

