/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.AttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.ISubQueryComputer;
import org.conqat.lib.commons.collections.SetMap;

public class InSubQuery
implements IQuery {
    private final AttributeOperand attribute;
    private final IQuery subQuery;

    public InSubQuery(AttributeOperand attribute, IQuery subQuery) {
        this.attribute = attribute;
        this.subQuery = subQuery;
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        Predicate<T> subQueryPredicate = this.subQuery.compile(context);
        Function<T, String> idAccessor = context.getIdAccessor();
        Function<T, String> identifierAttributeAccessor = InSubQuery.getIdentifierAttributeAccessor(context, this.attribute.toString());
        SubQueryComputer<T> subQueryComputer = new SubQueryComputer<T>(subQueryPredicate, idAccessor, identifierAttributeAccessor);
        context.addSubQueryComputer(subQueryComputer);
        return subQueryComputer::evaluate;
    }

    public String toString() {
        return String.format("%s in query(%s)", this.attribute, this.subQuery);
    }

    private static <T> Function<T, String> getIdentifierAttributeAccessor(ICompilationContext<T> context, String attributeName) throws QueryCompilationException {
        Function idAccessor = context.getIdAccessor();
        Function parentFieldAccessor = context.getAttributeAccessor(attributeName);
        BinaryOperator<String> parentFieldToIdTranslator = context.getIdResolver();
        return object -> (String)parentFieldToIdTranslator.apply((String)idAccessor.apply(object), (String)parentFieldAccessor.apply(object));
    }

    private static class SubQueryComputer<T>
    implements ISubQueryComputer<T> {
        private final Predicate<T> subQuery;
        private final Function<T, String> idAccessor;
        private final Function<T, String> identifierAttributeAccessor;
        private Long latestMatchingTimestamp = Long.MIN_VALUE;
        private final SetMap<Long, String> matching = new SetMap();

        private SubQueryComputer(Predicate<T> subQuery, Function<T, String> idAccessor, Function<T, String> identifierAttributeAccessor) {
            this.subQuery = subQuery;
            this.idAccessor = idAccessor;
            this.identifierAttributeAccessor = identifierAttributeAccessor;
        }

        @Override
        public void updateState(T object, long timestamp) {
            this.latestMatchingTimestamp = Math.max(this.latestMatchingTimestamp, timestamp);
            boolean matches = this.subQuery.test(object);
            if (matches) {
                this.matching.add((Object)timestamp, (Object)this.idAccessor.apply(object));
            }
        }

        public boolean evaluate(T object) {
            Set subSet = (Set)this.matching.getCollection((Object)this.latestMatchingTimestamp);
            String lhsAttributeValue = this.identifierAttributeAccessor.apply(object);
            return subSet != null && subSet.contains(lhsAttributeValue);
        }
    }
}

