/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.util.Arrays;
import java.util.List;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class PlainCommitLayeringDataLayout
implements ICommitLayeringDataLayout {
    private static final byte[] COMMIT_KEY_SEPARATOR = StringUtils.stringToBytes((String)"#-#");
    private static final byte[] COMMIT_KEY_PREFIX = StringUtils.stringToBytes((String)"#-#COMMIT#-#");
    private static final byte[] DATA_KEY_PREFIX = StringUtils.stringToBytes((String)"#-#DATA#-#");
    private static final byte[] DATA_KEY_PREFIX_SUCCESSOR = Arrays.copyOf(DATA_KEY_PREFIX, DATA_KEY_PREFIX.length);
    private static final byte[] HEAD_COMMIT_KEY_PREFIX;

    @Override
    public byte[] createCommitEntryKey(byte[] commitBinaryName, byte @Nullable [] key) {
        if (key == null) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{commitBinaryName, COMMIT_KEY_SEPARATOR});
        }
        return ByteArrayUtils.concat((byte[][])new byte[][]{commitBinaryName, COMMIT_KEY_SEPARATOR, key});
    }

    @Override
    public byte[] extractUnderlyingKeyFromCommitEntryKey(byte[] commitEntryKey) {
        int index = ByteArrayUtils.indexOf((byte[])COMMIT_KEY_SEPARATOR, (byte[])commitEntryKey, (int)0);
        if (index < 0) {
            throw new AssertionError((Object)("Passed a non-commit entry key to this method! Commit key separator not found. Offending key: " + StringUtils.encodeAsHex((byte[])commitEntryKey)));
        }
        return Arrays.copyOfRange(commitEntryKey, index + COMMIT_KEY_SEPARATOR.length, commitEntryKey.length);
    }

    @Override
    public byte[] createDataKey(byte[] referenceHash) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_KEY_PREFIX, referenceHash});
    }

    @Override
    public byte[] extractReferenceHash(byte[] dataKey) {
        return Arrays.copyOfRange(dataKey, DATA_KEY_PREFIX.length, dataKey.length);
    }

    @Override
    public int determineKeyOffset(byte[] commitName) {
        return commitName.length + COMMIT_KEY_SEPARATOR.length;
    }

    @Override
    public byte[] createCommitInfoKey(byte[] commitName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{COMMIT_KEY_PREFIX, commitName});
    }

    @Override
    public byte[] createBranchHeadKey(String branchName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{HEAD_COMMIT_KEY_PREFIX, StringUtils.stringToBytes((String)branchName)});
    }

    @Override
    public byte[] extractCommitNameFromCommitInfoKey(byte[] commitKey) {
        return Arrays.copyOfRange(commitKey, COMMIT_KEY_PREFIX.length, commitKey.length);
    }

    @Override
    public String extractBranchNameFromHeadKey(byte[] headKey) {
        return StringUtils.bytesToString((byte[])Arrays.copyOfRange(headKey, HEAD_COMMIT_KEY_PREFIX.length, headKey.length));
    }

    @Override
    public IBranchCommitInfo deserializeCommitInfo(byte[] bytes) throws StorageException {
        return (IBranchCommitInfo)StorageUtils.deserialize(bytes);
    }

    @Override
    public IBranchCommitInfo createInitialBranchCommitInfo(byte[] commitName, IStore underlyingStore) {
        return new BranchCommitInfo(commitName, null, null, 1, ECommitStatus.WRITEABLE);
    }

    @Override
    public IBranchCommitInfo createParentedBranchCommitInfo(byte[] commitName, IBranchCommitInfo parentCommit, byte[] deltaPredecessorCommitName, List<byte[]> deltaHierarchyCommitNamesForKeys, IStore underlyingStore) {
        byte[][] deltaHierarchyCommitNames = (byte[][])CollectionUtils.toArray(deltaHierarchyCommitNamesForKeys, byte[].class);
        return new BranchCommitInfo(commitName, parentCommit.getCommitName(), deltaHierarchyCommitNames, parentCommit.getDepth() + 1, ECommitStatus.WRITEABLE);
    }

    @Override
    public void scanAllCommitEntries(IStore store, IKeyValueCallback callback, boolean includeValues) throws StorageException {
        IKeyValueCallback filteringCallback = (key, value) -> {
            if (!ByteArrayUtils.isPrefix((byte[])COMMIT_KEY_PREFIX, (byte[])key) && !ByteArrayUtils.isPrefix((byte[])HEAD_COMMIT_KEY_PREFIX, (byte[])key)) {
                callback.callback(key, value);
            }
        };
        if (includeValues) {
            store.scan(new byte[0], DATA_KEY_PREFIX, filteringCallback);
            store.scan(DATA_KEY_PREFIX_SUCCESSOR, null, filteringCallback);
        } else {
            store.scanKeys(null, DATA_KEY_PREFIX, filteringCallback);
            store.scanKeys(DATA_KEY_PREFIX_SUCCESSOR, null, filteringCallback);
        }
    }

    static {
        int n = DATA_KEY_PREFIX_SUCCESSOR.length - 1;
        DATA_KEY_PREFIX_SUCCESSOR[n] = (byte)(DATA_KEY_PREFIX_SUCCESSOR[n] + 1);
        HEAD_COMMIT_KEY_PREFIX = StringUtils.stringToBytes((String)"#-#HEAD#-#");
    }
}

