/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.profiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemProviderBase;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.profiler.StorageProfiler;
import org.conqat.engine.persistence.store.profiler.StoreOperationStatistics;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DetailedStorageProfiler
extends StorageProfiler {
    private final boolean includeStorageSystemName;
    private final Map<String, Map<EStoreOperation, StoreOperationStatistics>> operationStatisticsByStore = new HashMap<String, Map<EStoreOperation, StoreOperationStatistics>>();
    private final CounterSet<String> storeOpens = new CounterSet();

    public DetailedStorageProfiler(boolean includeStorageSystemName) {
        this.includeStorageSystemName = includeStorageSystemName;
    }

    private synchronized void reportStats(String storeName, EStoreOperation operation, long startTimeNanos, long numberOfKeys, long keyBytesTransferred, long valueBytesTransferred) {
        this.operationStatisticsByStore.computeIfAbsent(storeName, k -> new HashMap()).merge(operation, new StoreOperationStatistics(System.nanoTime() - startTimeNanos, numberOfKeys, valueBytesTransferred, 1L, keyBytesTransferred), StoreOperationStatistics::aggregate);
        this.reportTime(startTimeNanos);
    }

    @Override
    public IStorageSystemProvider decorate(IStorageSystemProvider mainStorageSystemProvider) {
        return new DelegatingStorageSystemProviderBase(mainStorageSystemProvider){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IStore wrapStore(IStore store, String storeName, String storageSystemName) {
                if (DetailedStorageProfiler.this.includeStorageSystemName) {
                    storeName = storageSystemName + "/" + (String)storeName;
                }
                CounterSet<String> counterSet = DetailedStorageProfiler.this.storeOpens;
                synchronized (counterSet) {
                    DetailedStorageProfiler.this.storeOpens.inc(storeName);
                }
                return new DetailedProfilingStore((String)storeName, store);
            }
        };
    }

    public synchronized Map<String, Map<EStoreOperation, StoreOperationStatistics>> getOperationStatisticsByStore() {
        HashMap<String, Map<EStoreOperation, StoreOperationStatistics>> result = new HashMap<String, Map<EStoreOperation, StoreOperationStatistics>>();
        for (Map.Entry<String, Map<EStoreOperation, StoreOperationStatistics>> entry : this.operationStatisticsByStore.entrySet()) {
            HashMap<EStoreOperation, StoreOperationStatistics> copy = new HashMap<EStoreOperation, StoreOperationStatistics>();
            for (Map.Entry<EStoreOperation, StoreOperationStatistics> statEntry : entry.getValue().entrySet()) {
                copy.put(statEntry.getKey(), new StoreOperationStatistics(statEntry.getValue()));
            }
            result.put(entry.getKey(), copy);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getStoreOpenCounts() {
        CounterSet<String> counterSet = this.storeOpens;
        synchronized (counterSet) {
            return this.storeOpens.toMap();
        }
    }

    @IndexValueClass
    public static enum EStoreOperation {
        GET,
        PUT,
        SCAN,
        SCAN_KEYS,
        DELETE;

    }

    private class DetailedProfilingStore
    implements IStore {
        private final String storeName;
        private final IStore store;

        public DetailedProfilingStore(String storeName, IStore store) {
            this.storeName = storeName;
            this.store = store;
        }

        @Override
        public byte[] get(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            byte[] value = this.store.get(key);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.GET, start, 1L, key.length, DetailedProfilingStore.getByteArrayLengthSafe(value));
            return value;
        }

        private static int getByteArrayLengthSafe(byte[] value) {
            if (value != null) {
                return value.length;
            }
            return 0;
        }

        @Override
        public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            List<byte[]> values = this.store.get(keys);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.GET, start, keys.size(), keys.stream().mapToInt(DetailedProfilingStore::getByteArrayLengthSafe).sum(), values.stream().mapToInt(DetailedProfilingStore::getByteArrayLengthSafe).sum());
            return values;
        }

        @Override
        public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
            long start = System.nanoTime();
            this.store.put(key, value);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.PUT, start, 1L, key.length, value.length);
        }

        @Override
        public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
            long start = System.nanoTime();
            this.store.put(keysValues);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.PUT, start, keysValues.size(), keysValues.extractFirstList().stream().mapToInt(DetailedProfilingStore::getByteArrayLengthSafe).sum(), keysValues.extractSecondList().stream().mapToInt(DetailedProfilingStore::getByteArrayLengthSafe).sum());
        }

        @Override
        public void remove(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(key);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.DELETE, start, 1L, key.length, 0L);
        }

        @Override
        public void remove(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(keys);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.DELETE, start, keys.size(), keys.stream().mapToInt(DetailedProfilingStore::getByteArrayLengthSafe).sum(), 0L);
        }

        @Override
        public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
            long start = System.nanoTime();
            this.store.removeByPrefix(prefix);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.DELETE, start, 1L, prefix.length, 0L);
        }

        @Override
        public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            MeasuringKeyValueCallbackWrapper measuringCallback = new MeasuringKeyValueCallbackWrapper(callback);
            this.store.scan(beginKey, endKey, measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN, start, measuringCallback.keysTransferred.get(), measuringCallback.keyBytesTransferred.get(), measuringCallback.valueBytesTransferred.get());
        }

        @Override
        public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            MeasuringKeyValueCallbackWrapper measuringCallback = new MeasuringKeyValueCallbackWrapper(callback);
            this.store.scan(prefix, (IKeyValueCallback)measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN, start, measuringCallback.keysTransferred.get(), measuringCallback.keyBytesTransferred.get(), measuringCallback.valueBytesTransferred.get());
        }

        @Override
        public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            List measuringCallback = CollectionUtils.map(callbacks, MeasuringKeyValueCallbackWrapper::new);
            this.store.scan(prefixes, measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN, start, measuringCallback.stream().mapToLong(c -> c.keysTransferred.get()).sum(), measuringCallback.stream().mapToLong(c -> c.keyBytesTransferred.get()).sum(), measuringCallback.stream().mapToLong(c -> c.valueBytesTransferred.get()).sum());
        }

        @Override
        public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            MeasuringKeyValueCallbackWrapper measuringCallback = new MeasuringKeyValueCallbackWrapper(callback);
            this.store.scanKeys(beginKey, endKey, measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN_KEYS, start, measuringCallback.keysTransferred.get(), measuringCallback.keyBytesTransferred.get(), measuringCallback.valueBytesTransferred.get());
        }

        @Override
        public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            MeasuringKeyValueCallbackWrapper measuringCallback = new MeasuringKeyValueCallbackWrapper(callback);
            this.store.scanKeys(prefix, (IKeyValueCallback)measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN_KEYS, start, measuringCallback.keysTransferred.get(), measuringCallback.keyBytesTransferred.get(), measuringCallback.valueBytesTransferred.get());
        }

        @Override
        public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            List measuringCallback = CollectionUtils.map(callbacks, MeasuringKeyValueCallbackWrapper::new);
            this.store.scanKeys(prefixes, measuringCallback);
            DetailedStorageProfiler.this.reportStats(this.storeName, EStoreOperation.SCAN_KEYS, start, measuringCallback.stream().mapToLong(c -> c.keysTransferred.get()).sum(), measuringCallback.stream().mapToLong(c -> c.keyBytesTransferred.get()).sum(), measuringCallback.stream().mapToLong(c -> c.valueBytesTransferred.get()).sum());
        }

        @Override
        public Lock obtainLock(String suffix) {
            return this.store.obtainLock(suffix);
        }

        @Override
        public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
            return this.store.getCapability(capability);
        }

        @ThreadSafe
        private static class MeasuringKeyValueCallbackWrapper
        implements IKeyValueCallback {
            private final AtomicLong keysTransferred = new AtomicLong(0L);
            private final AtomicLong valueBytesTransferred = new AtomicLong(0L);
            private final AtomicLong keyBytesTransferred = new AtomicLong(0L);
            private final IKeyValueCallback callback;

            private MeasuringKeyValueCallbackWrapper(IKeyValueCallback callback) {
                this.callback = callback;
            }

            @Override
            public void callback(byte[] key, byte[] value) {
                this.valueBytesTransferred.addAndGet(DetailedProfilingStore.getByteArrayLengthSafe(value));
                this.keyBytesTransferred.addAndGet(key.length);
                this.keysTransferred.incrementAndGet();
                this.callback.callback(key, value);
            }
        }
    }
}

