/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.rocksdb;

import java.util.List;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.BatchHandlingStoreBase;
import org.conqat.engine.persistence.store.rocksdb.RocksDBStorageSystemProvider;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.jspecify.annotations.NonNull;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBStore
extends BatchHandlingStoreBase {
    private static final long MAXIMUM_WRITE_BATCH_SIZE = ByteUnit.GIBIBYTES.toBytes(5L);
    private final ReadOptions readOptions = new ReadOptions();
    private final WriteOptions writeOptions = new WriteOptions();
    private final RocksDB db;
    private final RocksDBStorageSystemProvider storageSystemProvider;

    public RocksDBStore(RocksDB db, RocksDBStorageSystemProvider storageSystemProvider) {
        super(new LocalLockProvider());
        this.db = db;
        this.storageSystemProvider = storageSystemProvider;
        this.readOptions.setVerifyChecksums(false);
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        this.throwIfShutdown();
        RocksDBStore.throwIfKeyIsNull(key);
        try {
            return this.db.get(this.readOptions, key);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    private void throwIfShutdown() throws StorageException {
        if (this.storageSystemProvider.isShutdown()) {
            throw new StorageException("Can not execute a method on a closed storage system!");
        }
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        this.throwIfShutdown();
        int index = 0;
        while (index < keysValues.size()) {
            try (WriteBatch writeBatch = new WriteBatch();){
                byte[] value;
                byte[] key;
                for (long bytesWritten = 0L; index < keysValues.size() && bytesWritten < MAXIMUM_WRITE_BATCH_SIZE; bytesWritten += (long)(key.length + value.length), ++index) {
                    key = (byte[])keysValues.getFirst(index);
                    value = (byte[])keysValues.getSecond(index);
                    writeBatch.put(key, value);
                }
                this.db.write(this.writeOptions, writeBatch);
            }
            catch (RocksDBException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.throwIfShutdown();
        try (WriteBatch writeBatch = new WriteBatch();){
            for (byte[] key : keys) {
                writeBatch.delete(key);
            }
            this.db.write(this.writeOptions, writeBatch);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.throwIfShutdown();
        RocksDBStore.throwIfKeyIsNull(key);
        if (value == null) {
            throw new StorageException("Cannot persist null values!");
        }
        try {
            this.db.put(this.writeOptions, key, value);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.throwIfShutdown();
        RocksDBStore.throwIfKeyIsNull(key);
        try {
            this.db.delete(this.writeOptions, key);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.throwIfShutdown();
        byte[] endKey = RocksDBStore.generateEndKey(prefix);
        try {
            this.db.deleteRange(this.writeOptions, prefix, endKey);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    @Override
    protected void doScan(byte @NonNull [] beginKey, byte[] endKey, IKeyValueCallback callback, boolean includeValue) throws StorageException {
        this.throwIfShutdown();
        try (ReadOptions options = new ReadOptions();){
            Slice slice = null;
            if (endKey != null) {
                slice = new Slice(endKey);
                options.setIterateUpperBound((AbstractSlice)slice);
            }
            try (RocksIterator iterator = this.db.newIterator(options);){
                iterator.seek(beginKey);
                RocksDBStore.iterateAndReport(iterator, includeValue, callback);
            }
            if (endKey != null) {
                slice.close();
            }
        }
    }

    private static void iterateAndReport(RocksIterator iterator, boolean includeValue, IKeyValueCallback callback) {
        while (iterator.isValid()) {
            byte[] key = iterator.key();
            byte[] value = null;
            if (includeValue) {
                value = iterator.value();
            }
            callback.callback(key, value);
            iterator.next();
        }
    }

    void setSnapshot(Snapshot snapshot) {
        this.readOptions.setSnapshot(snapshot);
    }
}

