/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.statistics;

import java.util.Arrays;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class StatisticsCollectingCallback
implements IKeyValueCallback {
    public static final String CSV_SEPARATOR = ";";
    public static final String CSV_HEADER = StringUtils.concat(Arrays.asList("Entries", "Overall Size", "Overall Key Size", "Overall Value Size", "Average Key Size", "Average Value Size", "Min Key Size", "Max Key Size", "Min Value Size", "Max Value Size"), (String)";");
    private long entryCount = 0L;
    private long keySize = 0L;
    private long valueSize = 0L;
    private int minKeyLength = Integer.MAX_VALUE;
    private int maxKeyLength = 0;
    private int minValueLength = Integer.MAX_VALUE;
    private int maxValueLength = 0;

    @Override
    public synchronized void callback(byte[] key, byte[] value) {
        ++this.entryCount;
        this.keySize += (long)key.length;
        this.minKeyLength = Math.min(this.minKeyLength, key.length);
        this.maxKeyLength = Math.max(this.maxKeyLength, key.length);
        if (value != null) {
            this.valueSize += (long)value.length;
            this.minValueLength = Math.min(this.minValueLength, value.length);
            this.maxValueLength = Math.max(this.maxValueLength, value.length);
        }
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public String toCsvString() {
        double divisor = Math.max(1L, this.entryCount);
        return this.entryCount + CSV_SEPARATOR + (this.keySize + this.valueSize) + CSV_SEPARATOR + this.keySize + CSV_SEPARATOR + this.valueSize + CSV_SEPARATOR + (double)this.keySize / divisor + CSV_SEPARATOR + (double)this.valueSize / divisor + CSV_SEPARATOR + this.minKeyLength + CSV_SEPARATOR + this.maxKeyLength + CSV_SEPARATOR + this.minValueLength + CSV_SEPARATOR + this.maxValueLength;
    }
}

