/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.transaction.TransactionalStorageSystem;
import org.conqat.lib.commons.factory.IFactory;

public class TransactionHandler {
    private final Map<String, TransactionalStorageSystem> openPartitions = new HashMap<String, TransactionalStorageSystem>();
    private final IFactory<IStore, StorageException> tempStoreCreator;
    private final StorageCacheProvider storageCacheProvider;

    public TransactionHandler(StorageCacheProvider storageCacheProvider, IFactory<IStore, StorageException> tempStoreCreator) {
        this.tempStoreCreator = tempStoreCreator;
        this.storageCacheProvider = storageCacheProvider;
    }

    public synchronized void commit() throws StorageException {
        for (TransactionalStorageSystem store : this.openPartitions.values()) {
            store.commit();
        }
    }

    public synchronized void rollback() throws StorageException {
        for (TransactionalStorageSystem store : this.openPartitions.values()) {
            store.rollback();
        }
    }

    public IStorageSystemProvider decorate(IStorageSystemProvider storageSystemProvider) {
        return new TransactionalStorageSystemProvider(storageSystemProvider);
    }

    private class TransactionalStorageSystemProvider
    implements IStorageSystemProvider {
        private final IStorageSystemProvider storageSystemProvider;

        public TransactionalStorageSystemProvider(IStorageSystemProvider storageSystemProvider) {
            this.storageSystemProvider = storageSystemProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStorageSystem openStorageSystem(String mainPartitionName) throws StorageException {
            TransactionHandler transactionHandler = TransactionHandler.this;
            synchronized (transactionHandler) {
                TransactionalStorageSystem partition = TransactionHandler.this.openPartitions.get(mainPartitionName);
                if (partition == null) {
                    partition = new TransactionalStorageSystem(this.storageSystemProvider.openStorageSystem(mainPartitionName), TransactionHandler.this.storageCacheProvider.getCacheProvider(mainPartitionName), TransactionHandler.this.tempStoreCreator);
                    TransactionHandler.this.openPartitions.put(mainPartitionName, partition);
                }
                return partition;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeStorageSystem(String projectName) throws StorageException {
            TransactionHandler transactionHandler = TransactionHandler.this;
            synchronized (transactionHandler) {
                TransactionHandler.this.openPartitions.remove(projectName);
                this.storageSystemProvider.removeStorageSystem(projectName);
                TransactionHandler.this.storageCacheProvider.invalidateCaches();
            }
        }

        @Override
        public void close() throws StorageException {
            this.storageSystemProvider.close();
        }

        @Override
        public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
            return this.storageSystemProvider.getCapability(capability);
        }
    }
}

