/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class StringAbbreviationSerializerBase<T> {
    private final StorageStringAbbreviator stringAbbreviator;
    private final List<T> elementsToSerialize = new ArrayList<T>();
    private Map<String, Integer> abbreviationMap = null;

    protected StringAbbreviationSerializerBase(StorageStringAbbreviator stringAbbreviator, List<T> elements) throws StorageException {
        this.stringAbbreviator = stringAbbreviator;
        this.addElementsToSerialize(elements);
        this.prepareStringLookup();
    }

    private void addElementsToSerialize(List<T> elementsToSerialize) {
        if (this.abbreviationMap != null) {
            throw new UnsupportedOperationException("The string lookup is already prepared. Either: Add all elements before starting serialization or use multiple serializers.");
        }
        this.elementsToSerialize.addAll(elementsToSerialize);
    }

    private void prepareStringLookup() throws StorageException {
        if (this.abbreviationMap != null) {
            return;
        }
        HashSet<String> stringsToAbbreviate = new HashSet<String>();
        for (T element : this.elementsToSerialize) {
            stringsToAbbreviate.addAll(this.getStringsToAbbreviate(element));
        }
        this.abbreviationMap = this.stringAbbreviator.buildAbbreviationMap(stringsToAbbreviate);
    }

    public abstract List<String> getStringsToAbbreviate(@Nullable T var1);

    public byte[] serialize(T element) {
        return this.serializeToByteArrayInternal(element, this.abbreviationMap);
    }

    protected abstract byte @NonNull [] serializeToByteArrayInternal(T var1, Map<String, Integer> var2);
}

