/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.QNameSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLObjectSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLObjectSupport.class);

    private XMLObjectSupport() {
    }

    public static <T extends XMLObject> T cloneXMLObject(@Nonnull T originalXMLObject) throws MarshallingException, UnmarshallingException {
        return XMLObjectSupport.cloneXMLObject(originalXMLObject, CloneOutputOption.DropDOM);
    }

    @Nonnull
    public static <T extends XMLObject> T cloneXMLObject(@Nonnull T originalXMLObject, @Nonnull CloneOutputOption cloneOutputOption) throws MarshallingException, UnmarshallingException {
        Element origElement = originalXMLObject.getDOM();
        if (origElement == null) {
            Marshaller marshaller = XMLObjectSupport.getMarshaller(originalXMLObject);
            if (marshaller == null) {
                throw new MarshallingException("Unable to obtain Marshaller for XMLObject: " + String.valueOf(originalXMLObject.getElementQName()));
            }
            origElement = marshaller.marshall(originalXMLObject);
        }
        Element clonedElement = null;
        switch (cloneOutputOption) {
            case RootDOMInNewDocument: {
                try {
                    ParserPool parser = XMLObjectProviderRegistrySupport.getParserPool();
                    if (parser == null) {
                        throw new XMLParserException("Unable to obtain ParserPool");
                    }
                    Document newDocument = parser.newDocument();
                    clonedElement = (Element)newDocument.importNode(origElement, true);
                    newDocument.appendChild(clonedElement);
                    break;
                }
                catch (XMLParserException e) {
                    throw new XMLRuntimeException("Error obtaining new Document from parser pool", (Exception)((Object)e));
                }
            }
            case UnrootedDOM: 
            case DropDOM: {
                clonedElement = (Element)origElement.cloneNode(true);
                break;
            }
            default: {
                throw new XMLRuntimeException("Saw unsupported value for CloneOutputOption enum: " + String.valueOf((Object)cloneOutputOption));
            }
        }
        assert (clonedElement != null);
        Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller(clonedElement);
        if (unmarshaller == null) {
            throw new UnmarshallingException("Unable to obtain Unmarshaller for element: " + String.valueOf(QNameSupport.getNodeQName((Node)clonedElement)));
        }
        XMLObject clonedXMLObject = unmarshaller.unmarshall(clonedElement);
        if (CloneOutputOption.DropDOM.equals((Object)cloneOutputOption)) {
            clonedXMLObject.releaseDOM();
            clonedXMLObject.releaseChildrenDOM(true);
        }
        return (T)clonedXMLObject;
    }

    @Nonnull
    public static XMLObject unmarshallFromInputStream(@Nonnull ParserPool parserPool, @Nonnull InputStream inputStream) throws XMLParserException, UnmarshallingException {
        LOG.debug("Parsing InputStream into DOM document");
        try {
            Document messageDoc = parserPool.parse(inputStream);
            Element messageElem = ElementSupport.ensureDocumentElement((Document)messageDoc);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resultant DOM message was:");
                LOG.trace(SerializeSupport.nodeToString((Node)messageElem));
            }
            LOG.debug("Unmarshalling DOM parsed from InputStream");
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller(messageElem);
            if (unmarshaller == null) {
                LOG.error("Unable to unmarshall InputStream, no unmarshaller registered for element " + String.valueOf(QNameSupport.getNodeQName((Node)messageElem)));
                throw new UnmarshallingException("Unable to unmarshall InputStream, no unmarshaller registered for element " + String.valueOf(QNameSupport.getNodeQName((Node)messageElem)));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            LOG.debug("InputStream succesfully unmarshalled");
            return message;
        }
        catch (RuntimeException e) {
            throw new UnmarshallingException("Fatal error unmarshalling XMLObject", e);
        }
    }

    @Nonnull
    public static XMLObject unmarshallFromReader(@Nonnull ParserPool parserPool, @Nonnull Reader reader) throws XMLParserException, UnmarshallingException {
        LOG.debug("Parsing Reader into DOM document");
        try {
            Document messageDoc = parserPool.parse(reader);
            Element messageElem = ElementSupport.ensureDocumentElement((Document)messageDoc);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resultant DOM message was:");
                LOG.trace(SerializeSupport.nodeToString((Node)messageElem));
            }
            LOG.debug("Unmarshalling DOM parsed from Reader");
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller(messageElem);
            if (unmarshaller == null) {
                LOG.error("Unable to unmarshall Reader, no unmarshaller registered for element " + String.valueOf(QNameSupport.getNodeQName((Node)messageElem)));
                throw new UnmarshallingException("Unable to unmarshall Reader, no unmarshaller registered for element " + String.valueOf(QNameSupport.getNodeQName((Node)messageElem)));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            LOG.debug("Reader succesfully unmarshalled");
            return message;
        }
        catch (RuntimeException e) {
            throw new UnmarshallingException("Fatal error unmarshalling XMLObject", e);
        }
    }

    @Nonnull
    public static Element marshall(@Nonnull XMLObject xmlObject) throws MarshallingException {
        LOG.debug("Marshalling XMLObject");
        Element domElement = xmlObject.getDOM();
        if (domElement != null) {
            LOG.debug("XMLObject already had cached DOM, returning that element");
            return domElement;
        }
        Marshaller marshaller = XMLObjectSupport.getMarshaller(xmlObject);
        if (marshaller == null) {
            LOG.error("Unable to marshall XMLObject, no marshaller registered for object: " + String.valueOf(xmlObject.getElementQName()));
            throw new MarshallingException("Unable to marshall XMLObject, no marshaller registered for object: " + String.valueOf(xmlObject.getElementQName()));
        }
        Element messageElem = marshaller.marshall(xmlObject);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Marshalled XMLObject into DOM:");
            LOG.trace(SerializeSupport.nodeToString((Node)messageElem));
        }
        return messageElem;
    }

    public static void marshallToOutputStream(@Nonnull XMLObject xmlObject, @Nonnull OutputStream outputStream) throws MarshallingException {
        Element element = XMLObjectSupport.marshall(xmlObject);
        SerializeSupport.writeNode((Node)element, (OutputStream)outputStream);
    }

    @Nullable
    public static String lookupNamespaceURI(XMLObject xmlObject, String prefix) {
        for (XMLObject current = xmlObject; current != null; current = current.getParent()) {
            for (Namespace ns : current.getNamespaces()) {
                if (!Objects.equals(ns.getNamespacePrefix(), prefix)) continue;
                return ns.getNamespaceURI();
            }
        }
        return null;
    }

    @Nullable
    public static String lookupNamespacePrefix(XMLObject xmlObject, String namespaceURI) {
        for (XMLObject current = xmlObject; current != null; current = current.getParent()) {
            for (Namespace ns : current.getNamespaces()) {
                if (!Objects.equals(ns.getNamespaceURI(), namespaceURI)) continue;
                return ns.getNamespacePrefix();
            }
        }
        return null;
    }

    public static void marshallAttribute(@Nonnull QName attributeName, @Nonnull List<String> attributeValues, @Nonnull Element domElement, boolean isIDAttribute) {
        XMLObjectSupport.marshallAttribute(attributeName, StringSupport.listToStringValue(attributeValues, (String)" "), domElement, isIDAttribute);
    }

    public static void marshallAttribute(@Nonnull QName attributeName, @Nullable String attributeValue, @Nonnull Element domElement, boolean isIDAttribute) {
        Document document = ElementSupport.ensureOwnerDocument((Element)domElement);
        Attr attribute = AttributeSupport.constructAttribute((Document)document, (QName)attributeName);
        attribute.setValue(attributeValue);
        domElement.setAttributeNodeNS(attribute);
        if (isIDAttribute) {
            domElement.setIdAttributeNode(attribute, true);
        }
    }

    public static void marshallAttributeMap(@Nonnull AttributeMap attributeMap, @Nonnull Element domElement) {
        Document document = ElementSupport.ensureOwnerDocument((Element)domElement);
        Attr attribute = null;
        for (Map.Entry<QName, String> entry : attributeMap.entrySet()) {
            QName key = entry.getKey();
            assert (key != null);
            attribute = AttributeSupport.constructAttribute((Document)document, (QName)key);
            attribute.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!XMLObjectProviderRegistrySupport.isIDAttribute(key) && !attributeMap.isIDAttribute(key)) continue;
            domElement.setIdAttributeNode(attribute, true);
        }
    }

    public static void marshallAttributeMapIDness(@Nonnull AttributeMap attributeMap, @Nonnull Element domElement) {
        for (QName qname : attributeMap.keySet()) {
            assert (qname != null);
            if (!XMLObjectProviderRegistrySupport.isIDAttribute(qname) && !attributeMap.isIDAttribute(qname)) continue;
            XMLObjectSupport.marshallAttributeIDness(qname, domElement, true);
        }
    }

    public static void marshallAttributeIDness(QName attributeName, Element domElement, boolean isIDAttribute) {
        XMLObjectSupport.marshallAttributeIDness(attributeName.getNamespaceURI(), attributeName.getLocalPart(), domElement, isIDAttribute);
    }

    public static void marshallAttributeIDness(String namespaceURI, String localPart, Element domElement, boolean isIDAttribute) {
        if (domElement.hasAttributeNS(namespaceURI, localPart)) {
            domElement.setIdAttributeNS(namespaceURI, localPart, isIDAttribute);
        }
    }

    public static void unmarshallToAttributeMap(@Nonnull AttributeMap attributeMap, @Nonnull Attr attribute) {
        QName attribQName = QNameSupport.getNodeQName((Node)attribute);
        attributeMap.put(attribQName, attribute.getValue());
        if (attribute.isId() || XMLObjectProviderRegistrySupport.isIDAttribute(attribQName)) {
            attributeMap.registerID(attribQName);
        }
    }

    @Nonnull
    public static XMLObject buildXMLObject(@Nonnull QName elementName) {
        XMLObjectBuilder builder = XMLObjectSupport.getProviderRegistry().getBuilderFactory().ensureBuilder(elementName);
        return builder.buildObject(elementName);
    }

    @Nonnull
    public static XMLObject buildXMLObject(@Nonnull QName elementName, @Nullable QName typeName) {
        XMLObjectBuilder builder = XMLObjectSupport.getProviderRegistry().getBuilderFactory().ensureBuilder(elementName);
        return builder.buildObject(elementName, typeName);
    }

    @Nullable
    public static XMLObjectBuilder<?> getBuilder(@Nonnull QName typeOrName) {
        return XMLObjectSupport.getProviderRegistry().getBuilderFactory().getBuilder(typeOrName);
    }

    @Nullable
    public static Marshaller getMarshaller(@Nonnull QName typeOrName) {
        return XMLObjectSupport.getProviderRegistry().getMarshallerFactory().getMarshaller(typeOrName);
    }

    @Nullable
    public static Marshaller getMarshaller(@Nonnull XMLObject xmlObject) {
        return XMLObjectSupport.getProviderRegistry().getMarshallerFactory().getMarshaller(xmlObject);
    }

    @Nullable
    public static Unmarshaller getUnmarshaller(@Nonnull QName typeOrName) {
        return XMLObjectSupport.getProviderRegistry().getUnmarshallerFactory().getUnmarshaller(typeOrName);
    }

    @Nullable
    public static Unmarshaller getUnmarshaller(@Nonnull Element element) {
        return XMLObjectSupport.getProviderRegistry().getUnmarshallerFactory().getUnmarshaller(element);
    }

    @Nonnull
    private static XMLObjectProviderRegistry getProviderRegistry() {
        XMLObjectProviderRegistry registry = ConfigurationService.get(XMLObjectProviderRegistry.class);
        if (registry == null) {
            throw new XMLRuntimeException("XMLObjectProviderRegistry was not available from the ConfigurationService");
        }
        return registry;
    }

    public static enum CloneOutputOption {
        DropDOM,
        RootDOMInNewDocument,
        UnrootedDOM;

    }
}

