/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.impl.cache.CacheConfiguration;
import com.teamscale.service.framework.impl.cache.CacheControlFilter;
import com.teamscale.service.framework.impl.cache.CacheControlUtils;
import com.teamscale.service.framework.impl.cache.ETagRevalidationFilter;
import com.teamscale.service.framework.impl.cache.ServerCacheHitFilter;
import com.teamscale.service.framework.impl.cache.ServerCacheInterceptor;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import org.glassfish.hk2.api.ServiceLocator;

@Provider
public class CacheFeature
implements DynamicFeature {
    @Context
    private ServiceLocator scopedLocator;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Cache cache;
        Method method = resourceInfo.getResourceMethod();
        if (!CacheFeature.shouldCacheResource(method, cache = (Cache)ServiceAnnotationUtils.getMethodOrClassAnnotation(Cache.class, (Method)method))) {
            CacheControl cacheControl = CacheControlUtils.initNoCacheControl();
            this.injectAndRegister(context, new CacheControlFilter(cacheControl));
        } else {
            CacheControl cacheControl = CacheControlUtils.initCacheControl(cache);
            this.injectAndRegister(context, new CacheControlFilter(cacheControl));
            if (cache.eTagContributors().length == 0) {
                this.injectAndRegister(context, new ServerCacheHitFilter());
                this.injectAndRegister(context, new ServerCacheInterceptor());
            } else {
                this.injectAndRegister(context, new ETagRevalidationFilter(cache));
            }
        }
    }

    private void injectAndRegister(FeatureContext context, Object component) {
        this.scopedLocator.inject(component);
        context.register(component);
    }

    private static boolean shouldCacheResource(Method method, Cache cache) {
        return !CacheConfiguration.getInstance().isServiceCacheDisabled() && method.isAnnotationPresent(GET.class) && cache != null;
    }
}

