/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.service.framework.impl.cache.ServerCacheInterceptor;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.glassfish.jersey.spi.ContentEncoder;

@Provider
@Priority(value=4000)
public class CacheIgnoringGZipEncoder
extends ContentEncoder {
    @Context
    private jakarta.inject.Provider<ContainerRequestContext> requestProvider;

    public CacheIgnoringGZipEncoder() {
        super(new String[]{"gzip", "x-gzip"});
    }

    public InputStream decode(String contentEncoding, InputStream encodedStream) throws IOException {
        return new GZIPInputStream(encodedStream);
    }

    public OutputStream encode(String contentEncoding, OutputStream entityStream) throws IOException {
        if (ServerCacheInterceptor.isCachedResponse((ContainerRequestContext)this.requestProvider.get())) {
            return entityStream;
        }
        return new GZIPOutputStream(entityStream);
    }
}

