/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.IETagContributor;
import com.teamscale.service.framework.impl.cache.CacheControlUtils;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

public class ETagRevalidationFilter
implements ContainerRequestFilter {
    private final Cache cacheAnnotation;
    private final ArrayList<IETagContributor> contributors;
    @Context
    private Request request;
    @Context
    private ITeamscaleServiceInfo serviceInfo;

    public ETagRevalidationFilter(Cache cacheAnnotation) {
        this.cacheAnnotation = cacheAnnotation;
        this.contributors = ETagRevalidationFilter.initContributors(cacheAnnotation);
    }

    public void filter(ContainerRequestContext request) {
        EntityTag etag = ETagRevalidationFilter.generateETag(request, this.serviceInfo, this.contributors);
        Response.ResponseBuilder builder = this.request.evaluatePreconditions(etag);
        if (builder != null) {
            request.setProperty("DO NOT CACHE AND ENCODE RESPONSE", (Object)true);
            CacheControl cc = CacheControlUtils.initCacheControl(this.cacheAnnotation);
            request.abortWith(builder.cacheControl(cc).header("ETag", (Object)etag).build());
        }
        request.setProperty("etag", (Object)etag);
    }

    private static EntityTag generateETag(ContainerRequestContext requestContext, ITeamscaleServiceInfo serviceInfo, List<IETagContributor> contributors) {
        StringBuilder etagBuilder = new StringBuilder();
        for (IETagContributor contributor : contributors) {
            try {
                etagBuilder.append(contributor.generateETagFragment(requestContext, serviceInfo));
            }
            catch (Exception e) {
                throw new InternalServerErrorException("Failed to generate ETag fragment with " + contributor.getClass().getSimpleName(), (Throwable)e);
            }
        }
        etagBuilder.append(ETeamscaleVersion.CURRENT_VERSION.toString());
        return new EntityTag(Long.toHexString(XXHashUtils.xxhash64((String)etagBuilder.toString())));
    }

    private static ArrayList<IETagContributor> initContributors(Cache cache) {
        Class[] eTagContributors = cache.eTagContributors();
        ArrayList<IETagContributor> contributors = new ArrayList<IETagContributor>();
        for (Class eTagContributor : eTagContributors) {
            try {
                contributors.add((IETagContributor)eTagContributor.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new InternalServerErrorException(eTagContributor.getName() + " must have a public no argument constructor.", (Throwable)e);
            }
        }
        return contributors;
    }
}

