/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.filter.request;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

@Provider
@PreMatching
@Priority(value=999)
public class LongUrlRewriteFilter
implements ContainerRequestFilter {
    private static final String X_ORIGINAL_METHOD_HEADER = "X-Original-Method";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (LongUrlRewriteFilter.isShortenedUrlRequest(requestContext)) {
            LongUrlRewriteFilter.rewriteRequestContext(requestContext, LongUrlRewriteFilter.getQueryString(requestContext));
        }
    }

    private static void rewriteRequestContext(ContainerRequestContext requestContext, String queryString) {
        requestContext.setEntityStream(null);
        requestContext.setMethod(requestContext.getHeaderString(X_ORIGINAL_METHOD_HEADER));
        requestContext.setRequestUri(requestContext.getUriInfo().getRequestUriBuilder().replaceQuery(queryString).build(new Object[0]));
    }

    private static String getQueryString(ContainerRequestContext requestContext) throws IOException {
        try (InputStream entityStream = requestContext.getEntityStream();){
            String string = new String(entityStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static boolean isShortenedUrlRequest(ContainerRequestContext requestContext) {
        return "POST".equalsIgnoreCase(requestContext.getMethod()) && requestContext.hasEntity() && ((List)requestContext.getHeaders().getOrDefault((Object)"Content-Type", Collections.emptyList())).contains("application/x-www-form-urlencoded") && requestContext.getHeaders().containsKey((Object)X_ORIGINAL_METHOD_HEADER) && StringUtils.isEmpty((String)requestContext.getUriInfo().getRequestUri().getQuery());
    }
}

