/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.logging;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.GlobalCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.ProjectCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.service.framework.logging.LogServiceUtils;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public final class ServiceLogHandlerUtils {
    private static final AtomicInteger PENDING_LOG_ENTRIES = new AtomicInteger(0);
    private static final Executor ASYNC_LOGGING_EXECUTOR = new ThreadPoolExecutor(1, 5, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(100), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy()){

        @Override
        public void execute(@NonNull Runnable command) {
            PENDING_LOG_ENTRIES.incrementAndGet();
            super.execute(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (PENDING_LOG_ENTRIES.decrementAndGet() == 0) {
                AtomicInteger atomicInteger = PENDING_LOG_ENTRIES;
                synchronized (atomicInteger) {
                    PENDING_LOG_ENTRIES.notifyAll();
                }
            }
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void waitForAllLogsToBeWritten() throws InterruptedException {
        while (PENDING_LOG_ENTRIES.get() > 0) {
            AtomicInteger atomicInteger = PENDING_LOG_ENTRIES;
            synchronized (atomicInteger) {
                PENDING_LOG_ENTRIES.wait();
            }
        }
    }

    public static IProjectId determineProject(ContainerRequestContext context) {
        if (context.getUriInfo().getPathParameters().get((Object)"project") != null) {
            return ProjectIdBase.convert((String)((String)((List)context.getUriInfo().getPathParameters().get((Object)"project")).get(0)));
        }
        return null;
    }

    public static void writeCriticalEventLog(ShortCriticalEventServiceLog shortCriticalEventLog, DetailedServiceLog detailedServiceLog, IndexLayer indexLayer, InternalProjectId projectId) {
        try {
            if (LogServiceUtils.requiresGlobalLog((IProjectId)projectId)) {
                GlobalCriticalEventServiceLogIndex globalLogIndex = LogServiceUtils.getGlobalCriticalEventLogIndex((IndexLayer)indexLayer);
                globalLogIndex.insertLog((ShortLogEntryBase)shortCriticalEventLog, (DetailedLogEntryBase)detailedServiceLog);
            } else {
                ProjectCriticalEventServiceLogIndex projectLogIndex = LogServiceUtils.getProjectCriticalEventLogIndex((IndexLayer)indexLayer, (IProjectId)projectId);
                projectLogIndex.insertLog((ShortLogEntryBase)shortCriticalEventLog, (DetailedLogEntryBase)detailedServiceLog);
            }
        }
        catch (StorageException e) {
            ServiceLogHandlerUtils.fallbackToLog4jLogging(shortCriticalEventLog.getEventMessage(), detailedServiceLog, e);
        }
    }

    private static void fallbackToLog4jLogging(String message, DetailedServiceLog detailedServiceLog, StorageException e) {
        ServiceLogHandlerUtils.writeServiceLogWithLog4j(message, detailedServiceLog);
        LOGGER.error("Error attempting to write log to index (see original log message above): " + e.getMessage());
    }

    private static void writeServiceLogWithLog4j(String message, DetailedServiceLog detailedServiceLog) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(message);
        if (detailedServiceLog != null) {
            for (LoggingEventTransport event : detailedServiceLog.getLoggingEvents()) {
                logMessage.append(event.toString());
                logMessage.append("\n");
            }
        }
        LOGGER.error((CharSequence)logMessage);
    }

    public static void writeInteractionLog(InternalProjectId project, long timestamp, String target, List<LogEvent> logEvents, IndexLayer indexLayer) {
        List interactionLogEvents = CollectionUtils.filter(logEvents, LoggingUtils::isInteractionLog);
        if (interactionLogEvents.isEmpty()) {
            return;
        }
        ASYNC_LOGGING_EXECUTOR.execute(() -> {
            try {
                LogIndexBase<ShortInteractionLog, DetailedWorkerLog> interactionLogIndex = ServiceLogHandlerUtils.getInteractionLogIndex(indexLayer, project);
                for (LogEvent interactionLogEvent : interactionLogEvents) {
                    interactionLogIndex.insertLog((ShortLogEntryBase)new ShortInteractionLog(LogEntryIdentifier.freshWithTimestamp((long)timestamp), target, project, null, interactionLogEvent.getMessage()), null);
                }
            }
            catch (StorageException e) {
                ServiceLogHandlerUtils.fallbackToLog4jLogging("Could not log interaction", null, e);
            }
        });
    }

    public static void writeServiceLog(ShortServiceLog shortServiceLog, DetailedServiceLog detailedServiceLog, ELogLevel serviceLogLevel, IndexLayer indexLayer, IProjectId project) {
        if (!ServiceLogHandlerUtils.shouldWriteLog(shortServiceLog.getLogCount(), serviceLogLevel)) {
            return;
        }
        ASYNC_LOGGING_EXECUTOR.execute(() -> {
            try {
                ServiceLogHandlerUtils.getLogIndex(indexLayer, project).insertLog((ShortLogEntryBase)shortServiceLog, (DetailedLogEntryBase)detailedServiceLog);
            }
            catch (StorageException e) {
                ServiceLogHandlerUtils.fallbackToLog4jLogging(shortServiceLog.toString(), detailedServiceLog, e);
            }
        });
    }

    private static LogIndexBase<ShortServiceLog, DetailedServiceLog> getLogIndex(IndexLayer indexLayer, IProjectId project) throws StorageException {
        if (LogServiceUtils.requiresGlobalLog((IProjectId)project)) {
            return LogServiceUtils.getGlobalServiceLogIndex((IndexLayer)indexLayer);
        }
        return LogServiceUtils.getProjectServiceLogIndex((IndexLayer)indexLayer, (IProjectId)project);
    }

    private static LogIndexBase<ShortInteractionLog, DetailedWorkerLog> getInteractionLogIndex(IndexLayer indexLayer, InternalProjectId project) throws StorageException {
        if (LogServiceUtils.requiresGlobalLog((IProjectId)project)) {
            return LogServiceUtils.getGlobalInteractionLogIndex((IndexLayer)indexLayer);
        }
        return LogServiceUtils.getProjectInteractionLogIndex((IndexLayer)indexLayer, (IProjectId)project);
    }

    private static boolean shouldWriteLog(LogCount logCount, ELogLevel logLevel) {
        return switch (logLevel) {
            default -> throw new MatchException(null, null);
            case ELogLevel.OFF, ELogLevel.FATAL -> false;
            case ELogLevel.ERROR -> {
                if (logCount.errorAndFatal() > 0) {
                    yield true;
                }
                yield false;
            }
            case ELogLevel.WARN -> {
                if (logCount.warningAndHigher() > 0) {
                    yield true;
                }
                yield false;
            }
            case ELogLevel.ALL, ELogLevel.TRACE, ELogLevel.DEBUG, ELogLevel.INFO -> true;
        };
    }

    private ServiceLogHandlerUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

