/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
public class LogEntryIdentifierConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type type, Annotation[] annotations) {
        if (rawType.isAssignableFrom(LogEntryIdentifier.class)) {
            return new FunctionalConverter(annotations, LogEntryIdentifierConverterProvider::convert);
        }
        return null;
    }

    private static LogEntryIdentifier convert(String encoded) throws InvalidValueException {
        if (encoded == null) {
            return null;
        }
        try {
            return LogEntryIdentifier.decodeIdentifier((String)encoded);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

