/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;

@Provider
public class UnresolvedCommitDescriptorConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(UnresolvedCommitDescriptor.class)) {
            return new FunctionalConverter(annotations, UnresolvedCommitDescriptorConverterProvider::convert);
        }
        return null;
    }

    private static UnresolvedCommitDescriptor convert(String commitString) throws InvalidValueException {
        try {
            return UnresolvedCommitDescriptorUtils.parseCommit((String)commitString);
        }
        catch (BadRequestException | IllegalArgumentException e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

