/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.ModifierFlags;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

abstract class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    JavaMethodElementType(@NonNls String name) {
        super(name);
    }

    @Override
    public PsiMethod createPsi(@NotNull PsiMethodStub stub) {
        if (stub == null) {
            JavaMethodElementType.$$$reportNull$$$0(0);
        }
        return this.getPsiFactory(stub).createMethod(stub);
    }

    @Override
    public PsiMethod createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaMethodElementType.$$$reportNull$$$0(1);
        }
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    @Override
    @NotNull
    public PsiMethodStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            JavaMethodElementType.$$$reportNull$$$0(2);
        }
        if (node == null) {
            JavaMethodElementType.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            JavaMethodElementType.$$$reportNull$$$0(4);
        }
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type2 == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type2 == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List<LighterASTNode> params = LightTreeUtil.getChildrenOfType(tree, child, JavaElementType.PARAMETER);
                if (params.isEmpty() || (pType = LightTreeUtil.firstChildOfType(tree, params.get(params.size() - 1), JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType(tree, pType, JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type2 == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2) || type2 == JavaTokenType.SEMICOLON || type2 == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString(tree, child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiMethodStubImpl(parentStub, name, typeInfo, flags, defValueText);
    }

    @Override
    public void serialize(@NotNull PsiMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaMethodElementType.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            JavaMethodElementType.$$$reportNull$$$0(6);
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText());
        dataStream.writeByte(((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    @Override
    @NotNull
    public PsiMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaMethodElementType.$$$reportNull$$$0(7);
        }
        String name = dataStream.readNameString();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        String defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readNameString() : null;
        return new PsiMethodStubImpl(parentStub, name, type2, flags, defaultMethodValue);
    }

    @Override
    public void indexStub(@NotNull PsiMethodStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            JavaMethodElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            JavaMethodElementType.$$$reportNull$$$0(9);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, name);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub.getReturnTypeText().getShortTypeText());
            }
        }
        Set<String> methodTypeParams = JavaMethodElementType.getVisibleTypeParameters(stub);
        for (StubElement stubElement : stub.getChildrenStubs()) {
            if (!(stubElement instanceof PsiParameterListStub)) continue;
            for (StubElement paramStub : stubElement.getChildrenStubs()) {
                if (!(paramStub instanceof PsiParameterStub)) continue;
                TypeInfo type2 = ((PsiParameterStub)paramStub).getType();
                String typeName = PsiNameHelper.getShortClassName(type2.text);
                if (TypeConversionUtil.isPrimitive(typeName) || TypeConversionUtil.isPrimitiveWrapper(typeName) || methodTypeParams.contains(typeName)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, typeName);
            }
        }
    }

    @NotNull
    private static Set<String> getVisibleTypeParameters(@NotNull StubElement<?> stub) {
        if (stub == null) {
            JavaMethodElementType.$$$reportNull$$$0(10);
        }
        HashSet<String> result2 = null;
        while (stub != null) {
            Set<String> names2 = JavaMethodElementType.getOwnTypeParameterNames(stub);
            if (!names2.isEmpty()) {
                if (result2 == null) {
                    result2 = new HashSet<String>();
                }
                result2.addAll(names2);
            }
            if (JavaMethodElementType.isStatic(stub)) break;
            stub = stub.getParentStub();
        }
        Set<String> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            JavaMethodElementType.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static boolean isStatic(@NotNull StubElement<?> stub) {
        PsiModifierListStub modList;
        if (stub == null) {
            JavaMethodElementType.$$$reportNull$$$0(12);
        }
        if (stub instanceof PsiMemberStub && (modList = stub.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)) != null) {
            return BitUtil.isSet(modList.getModifiersMask(), ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.getInt("static"));
        }
        return false;
    }

    private static Set<String> getOwnTypeParameterNames(StubElement<?> stubElement) {
        PsiTypeParameterListStub typeParamList = stubElement.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
        if (typeParamList == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodTypeParams = null;
        for (StubElement tStub : typeParamList.getChildrenStubs()) {
            if (!(tStub instanceof PsiTypeParameterStub)) continue;
            if (methodTypeParams == null) {
                methodTypeParams = new HashSet<String>();
            }
            methodTypeParams.add(((PsiTypeParameterStub)tStub).getName());
        }
        return methodTypeParams == null ? Collections.emptySet() : methodTypeParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaMethodElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaMethodElementType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleTypeParameters";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

