/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FunctionDelegateMemberNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class FunctionDelegateMemberNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final FunctionDelegateMemberNameClashChecker INSTANCE = new FunctionDelegateMemberNameClashChecker();

    private FunctionDelegateMemberNameClashChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context, "context");
                if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (!(container instanceof ClassDescriptor) || !((ClassDescriptor)container).isFun()) {
                    return;
                }
                if (((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter() != null) break block7;
                List<ValueParameterDescriptor> list2 = ((CallableMemberDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
                if (!(!((Collection)list2).isEmpty())) break block8;
            }
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getName().asString(), "getFunctionDelegate") || descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "functionDelegate")) {
            PsiElement psiElement = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
            if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                psiElement = declaration;
            }
            PsiElement reportOn = psiElement;
            context.getTrace().report(ErrorsJvm.FUNCTION_DELEGATE_MEMBER_NAME_CLASH.on(reportOn));
        }
    }
}

