/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.recognizers;

import org.sonarsource.analyzer.commons.recognizers.Detector;

public class EndWithDetector
extends Detector {
    private final char[] endOfLines;

    public EndWithDetector(double probability, char ... endOfLines) {
        super(probability);
        this.endOfLines = endOfLines;
    }

    @Override
    public int scan(String line) {
        for (int index2 = line.length() - 1; index2 >= 0; --index2) {
            char character = line.charAt(index2);
            for (char endOfLine : this.endOfLines) {
                if (character != endOfLine) continue;
                return 1;
            }
            if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
            return 0;
        }
        return 0;
    }
}

