/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.recognizers;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.sonarsource.analyzer.commons.recognizers.Detector;

public class KeywordsDetector
extends Detector {
    private final List<String> keywords;
    private boolean toUpperCase = false;

    public KeywordsDetector(double probability, String ... keywords) {
        super(probability);
        this.keywords = Arrays.asList(keywords);
    }

    public KeywordsDetector(double probability, boolean toUpperCase, String ... keywords) {
        this(probability, keywords);
        this.toUpperCase = toUpperCase;
    }

    @Override
    public int scan(String line) {
        int matchers = 0;
        if (this.toUpperCase) {
            line = line.toUpperCase(Locale.getDefault());
        }
        StringTokenizer tokenizer = new StringTokenizer(line, " \t(),{}");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!this.keywords.contains(word)) continue;
            ++matchers;
        }
        return matchers;
    }
}

