/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.sensors;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.kotlin.api.common.ConstantsKt;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.ParseException;
import org.sonarsource.kotlin.api.logging.LoggerExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"EMPTY_FILE_CONTENT_PATTERN", "Lkotlin/text/Regex;", "determineKotlinLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "logger", "Lorg/slf4j/Logger;", "determineNumberOfThreadsToUse", "", "(Lorg/sonar/api/batch/sensor/SensorContext;Lorg/slf4j/Logger;)Ljava/lang/Integer;", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "toParseException", "Lorg/sonarsource/kotlin/api/frontend/ParseException;", "action", "", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "cause", "", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinSensorExecuteContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinSensorExecuteContext.kt\norg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class AbstractKotlinSensorExecuteContextKt {
    @NotNull
    private static final Regex EMPTY_FILE_CONTENT_PATTERN = new Regex("\\s*+");

    @NotNull
    public static final Environment environment(@NotNull SensorContext sensorContext, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(logger, "logger");
        String[] stringArray = sensorContext.config().getStringArray("sonar.java.binaries");
        Intrinsics.checkNotNullExpressionValue(stringArray, "getStringArray(...)");
        Collection collection = ArraysKt.toList((Object[])stringArray);
        String[] stringArray2 = sensorContext.config().getStringArray("sonar.java.libraries");
        Intrinsics.checkNotNullExpressionValue(stringArray2, "getStringArray(...)");
        return new Environment(CollectionsKt.plus(collection, (Iterable)ArraysKt.toList((Object[])stringArray2)), AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion(sensorContext, logger), null, AbstractKotlinSensorExecuteContextKt.determineNumberOfThreadsToUse(sensorContext, logger), 4, null);
    }

    private static final Integer determineNumberOfThreadsToUse(SensorContext sensorContext, Logger logger) {
        Object var2_2 = sensorContext.config().get("sonar.kotlin.threads").map(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineNumberOfThreadsToUse$lambda$0(new Function1<String, Integer>(logger){
            final /* synthetic */ Logger $logger;
            {
                this.$logger = $logger;
                super(1);
            }

            @Nullable
            public final Integer invoke(String stringInput) {
                Integer n;
                Object object;
                Object object2;
                try {
                    boolean bl = false;
                    Intrinsics.checkNotNull(stringInput);
                    object2 = Result.constructor-impl(Integer.parseInt(((Object)StringsKt.trim((CharSequence)stringInput)).toString()));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                Logger logger = this.$logger;
                Throwable throwable = Result.exceptionOrNull-impl(object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    Throwable it = throwable;
                    boolean bl = false;
                    logger.warn("sonar.kotlin.threads needs to be set to an integer value. Could not interpret '" + stringInput + "' as integer.");
                    object = null;
                }
                Integer n2 = (Integer)object;
                if (n2 != null) {
                    object2 = n2;
                    logger = this.$logger;
                    int threadCount = ((Number)object2).intValue();
                    boolean bl = false;
                    if (threadCount > 0) {
                        n = threadCount;
                    } else {
                        logger.warn("Invalid amount of threads specified for sonar.kotlin.threads: '" + stringInput + "'.");
                        n = null;
                    }
                } else {
                    n = null;
                }
                return n;
            }
        }, arg_0)).orElse(null);
        Integer it = var2_2;
        boolean bl = false;
        LoggerExtensionsKt.debug(logger, new Function0<String>(it){
            final /* synthetic */ Integer $it;
            {
                this.$it = $it;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object = this.$it;
                if (object == null) {
                    object = "the default amount of";
                }
                return "Using " + object + " threads";
            }
        });
        return var2_2;
    }

    private static final LanguageVersion determineKotlinLanguageVersion(SensorContext sensorContext, Logger logger) {
        LanguageVersion languageVersion;
        LanguageVersion languageVersion2 = sensorContext.config().get("sonar.kotlin.source.version").map(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$2(new Function1<String, LanguageVersion>(logger){
            final /* synthetic */ Logger $logger;
            {
                this.$logger = $logger;
                super(1);
            }

            @Nullable
            public final LanguageVersion invoke(String versionString) {
                LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(versionString);
                Logger logger = this.$logger;
                LanguageVersion langVersion = languageVersion;
                boolean bl = false;
                if (langVersion == null) {
                    Intrinsics.checkNotNull(versionString);
                    if (!StringsKt.isBlank(versionString)) {
                        logger.warn("Failed to find Kotlin version '" + versionString + "'. Defaulting to " + ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION().getVersionString());
                    }
                }
                return languageVersion;
            }
        }, arg_0)).orElse(null);
        if (languageVersion2 == null) {
            languageVersion2 = ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION();
        }
        LanguageVersion it = languageVersion = languageVersion2;
        boolean bl = false;
        LoggerExtensionsKt.debug(logger, new Function0<String>(it){
            final /* synthetic */ LanguageVersion $it;
            {
                this.$it = $it;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Using Kotlin " + this.$it.getVersionString() + " to parse source code";
            }
        });
        return languageVersion;
    }

    private static final ParseException toParseException(String action, InputFile inputFile, Throwable cause) {
        ParseException parseException = cause instanceof ParseException ? (ParseException)cause : null;
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), (TextPointer)(parseException != null ? parseException.getPosition() : null), cause);
    }

    private static final Integer determineNumberOfThreadsToUse$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final LanguageVersion determineKotlinLanguageVersion$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (LanguageVersion)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Regex access$getEMPTY_FILE_CONTENT_PATTERN$p() {
        return EMPTY_FILE_CONTENT_PATTERN;
    }

    public static final /* synthetic */ ParseException access$toParseException(String action, InputFile inputFile, Throwable cause) {
        return AbstractKotlinSensorExecuteContextKt.toParseException(action, inputFile, cause);
    }
}

