/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.WebViewJavaScriptSupportCheckKt;

@Rule(key="S6362")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/checks/WebViewJavaScriptSupportCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "checkJavaScriptEnabledArgument", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitFunctionCall", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "sonar-kotlin-checks"})
public final class WebViewJavaScriptSupportCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(WebViewJavaScriptSupportCheckKt.access$getANDROID_SET_JAVASCRIPT_ENABLED$p());

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.checkJavaScriptEnabledArgument(kotlinFileContext, CallUtilKt.getFirstArgumentExpression(resolvedCall2));
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ) && ApiExtensionsKt.setterMatches(KtPsiUtil.deparenthesize(expression2.getLeft()), ctx.getBindingContext(), "javaScriptEnabled", WebViewJavaScriptSupportCheckKt.access$getANDROID_SET_JAVASCRIPT_ENABLED$p())) {
            this.checkJavaScriptEnabledArgument(ctx, expression2.getRight());
        }
    }

    private final void checkJavaScriptEnabledArgument(KotlinFileContext ctx, KtExpression argument) {
        KtExpression ktExpression = argument;
        if (ktExpression != null ? Intrinsics.areEqual(ApiExtensionsKt.predictRuntimeBooleanValue(ktExpression, ctx.getBindingContext()), true) : false) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)argument, "Make sure that enabling JavaScript support is safe here.", null, null, 12, null);
        }
    }
}

