/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.Optional;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.PortLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class SimulinkPortBase
extends ParameterizedElement {
    private SimulinkBlock block;
    private final SimulinkPortBuilder.EPortType portType;
    private final String index;
    private final @Nullable FlexiblePortPlacementParameters flexiblePortPlacementParameters;

    protected SimulinkPortBase(@NonNull SimulinkBlock block, SimulinkPortBuilder.EPortType portType, String index, @Nullable FlexiblePortPlacementParameters flexiblePortPlacementParameters) {
        this.block = block;
        this.portType = portType;
        this.index = index;
        this.flexiblePortPlacementParameters = flexiblePortPlacementParameters;
    }

    public String getIndex() {
        return this.index;
    }

    public SimulinkBlock getBlock() {
        return this.block;
    }

    public String toString() {
        return this.index + "@" + this.block.getId();
    }

    public void remove() {
        this.block = null;
    }

    public abstract boolean isConnected();

    public abstract Optional<String> getSignalName();

    @SimulinkTestExclude
    public PortLayoutData obtainLayoutData() {
        return this.getBlock().getModel().getModelDataHandler().getSimulinkLayoutHandler().obtainPortLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelData() {
        return SimulinkLayoutHandler.obtainPortLabelData(this);
    }

    public boolean isSpecialPort() {
        return false;
    }

    public SimulinkPortBuilder.EPortType getPortType() {
        return this.portType;
    }

    public Optional<FlexiblePortPlacementParameters> getFlexiblePortPlacementParameters() {
        return Optional.ofNullable(this.flexiblePortPlacementParameters);
    }
}

