/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.datahandler.RectangleLayoutData;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;

public abstract class StateflowNodeBase
extends StateflowDeclContainerBase<IStateflowNodeContainer<?>> {
    private final IdentityHashSet<StateflowTransition> inTransitions = new IdentityHashSet();
    private final IdentityHashSet<StateflowTransition> outTransitions = new IdentityHashSet();

    protected StateflowNodeBase() {
    }

    public abstract String buildQualifiedName();

    void addInTransition(StateflowTransition transition) {
        CCSMAssert.isTrue((transition.getDst() == this ? 1 : 0) != 0, (String)"Transition destination element does not match");
        this.inTransitions.add((Object)transition);
    }

    void addOutTransition(StateflowTransition transition) {
        CCSMAssert.isTrue((transition.getSrc() == this ? 1 : 0) != 0, (String)"Transition source element does not match");
        this.outTransitions.add((Object)transition);
    }

    public UnmodifiableSet<StateflowTransition> getInTransitions() {
        return CollectionUtils.asUnmodifiable(this.inTransitions);
    }

    public UnmodifiableSet<StateflowTransition> getOutTransitions() {
        return CollectionUtils.asUnmodifiable(this.outTransitions);
    }

    @Override
    public void remove() {
        IStateflowNodeContainer parent = (IStateflowNodeContainer)this.getParent();
        CCSMAssert.isFalse((parent == null ? 1 : 0) != 0, (String)"Node has no parent to be removed from.");
        if (parent instanceof StateflowChart) {
            ((StateflowChart)parent).removeNode(this);
        } else if (parent instanceof StateflowState) {
            ((StateflowState)parent).removeNode(this);
        } else {
            CCSMAssert.fail((String)("Unknown Stateflow container: " + String.valueOf(parent)));
        }
        for (StateflowTransition transition : new ArrayList<StateflowTransition>((Collection<StateflowTransition>)this.inTransitions)) {
            transition.remove();
        }
        for (StateflowTransition transition : new ArrayList<StateflowTransition>((Collection<StateflowTransition>)this.outTransitions)) {
            transition.remove();
        }
    }

    void removeInTransition(StateflowTransition transition) {
        CCSMAssert.isTrue((boolean)this.inTransitions.contains((Object)transition), (String)"Transition does not belong to this node.");
        this.inTransitions.remove((Object)transition);
    }

    void removeOutTransition(StateflowTransition transition) {
        CCSMAssert.isTrue((boolean)this.outTransitions.contains((Object)transition), (String)"Transition does not belong to this node.");
        this.outTransitions.remove((Object)transition);
    }

    @SimulinkTestExclude
    public abstract RectangleLayoutData obtainLayoutData();

    public StateflowMachine getMachine() {
        return this.getParentChart().getMachine();
    }
}

