/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.types;

import java.math.BigDecimal;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.simulink.types.ENumericDataType;

public class NarrowestContainingTypeMatrix {
    private static final byte[][] NARROWEST_CONTAINING_TYPE_MATRIX = NarrowestContainingTypeMatrix.initializeMatrix();

    private static byte[][] initializeMatrix() {
        ENumericDataType[] types = ENumericDataType.values();
        CCSMAssert.isTrue((types.length < 127 ? 1 : 0) != 0, (String)"ENumericDataType got too large to store the ordinals in bytes. Just replace all byte types in this class with int.");
        byte[][] narrowestContainingType = new byte[types.length][types.length];
        for (int i = 0; i < types.length; ++i) {
            for (int j = i; j < types.length; ++j) {
                ENumericDataType type1 = types[i];
                ENumericDataType type2 = types[j];
                ENumericDataType containingType = NarrowestContainingTypeMatrix.computeNarrowestTypeContainingRangesOf(type1, type2);
                NarrowestContainingTypeMatrix.put(type2, type1, containingType, narrowestContainingType);
            }
        }
        return narrowestContainingType;
    }

    private static ENumericDataType computeNarrowestTypeContainingRangesOf(ENumericDataType type1, ENumericDataType type2) {
        if (type1 == ENumericDataType.BOOLEAN && type2 == ENumericDataType.BOOLEAN) {
            return ENumericDataType.BOOLEAN;
        }
        ENumericDataType[] allTypes = ENumericDataType.values();
        ENumericDataType bestFitType = null;
        BigDecimal max = type1.max().max(type2.max());
        BigDecimal min = type1.min().min(type2.min());
        BigDecimal width = ENumericDataType.DOUBLE.max().subtract(ENumericDataType.DOUBLE.min()).add(BigDecimal.ONE);
        for (ENumericDataType candidate : allTypes) {
            BigDecimal cWidth = candidate.max().subtract(candidate.min());
            if (!candidate.rangeContains(min) || !candidate.rangeContains(max) || cWidth.compareTo(width) > 0) continue;
            width = cWidth;
            bestFitType = candidate;
        }
        return bestFitType;
    }

    private static void put(ENumericDataType type1, ENumericDataType type2, ENumericDataType value, byte[][] matrix) {
        matrix[type1.ordinal()][type2.ordinal()] = (byte)value.ordinal();
        matrix[type2.ordinal()][type1.ordinal()] = (byte)value.ordinal();
    }

    public static ENumericDataType getNarrowestContainingType(ENumericDataType type1, ENumericDataType type2) {
        return ENumericDataType.values()[NARROWEST_CONTAINING_TYPE_MATRIX[type1.ordinal()][type2.ordinal()]];
    }
}

