/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.ui.SimulinkUiDataBase;
import org.conqat.lib.simulink.ui.StateflowNodeUiData;
import org.conqat.lib.simulink.ui.StateflowTransitionUiData;
import org.conqat.lib.simulink.util.StateflowUtils;

public class SimulinkChartUiData
extends SimulinkUiDataBase {
    private static final String NODES_PROPERTY = "nodes";
    private static final String TRANSITIONS_PROPERTY = "transitions";
    @JsonProperty(value="nodes")
    private final List<StateflowNodeUiData> nodes = new ArrayList<StateflowNodeUiData>();
    @JsonProperty(value="transitions")
    private final List<StateflowTransitionUiData> transitions = new ArrayList<StateflowTransitionUiData>();

    @JsonCreator
    public SimulinkChartUiData(@JsonProperty(value="name") String name, @JsonProperty(value="qualifiedName") String qualifiedName) {
        super(name, qualifiedName);
    }

    public SimulinkChartUiData(StateflowChart chart) {
        super(StringUtils.getLastPart((String)chart.buildQualifiedName(), (String)"/"), chart.buildQualifiedName());
        for (StateflowNodeBase node : chart.getNodes()) {
            this.nodes.add(new StateflowNodeUiData(node));
        }
        this.transitions.addAll(CollectionUtils.map(StateflowUtils.getNonCrossingTransitions(chart), StateflowTransitionUiData::new));
    }

    public List<StateflowNodeUiData> getNodes() {
        return this.nodes;
    }
}

