/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.datahandler.EHorizontalAlignment;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;

public class RendererBase {
    protected static final int OUTPUT_CANVAS_PADDING = 10;

    protected static Graphics2D createGraphics(Rectangle canvasRectangle, BufferedImage image) {
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, canvasRectangle.width, canvasRectangle.height);
        graphics.translate(-canvasRectangle.x, -canvasRectangle.y);
        return graphics;
    }

    protected static void renderLabel(LabelLayoutData labelData, Graphics2D graphics) {
        RendererBase.renderLabel(labelData, EHorizontalAlignment.CENTER, graphics, false);
    }

    protected static void renderLabel(LabelLayoutData labelData, EHorizontalAlignment horizontalAlignment, Graphics2D graphics, boolean normalizeHtml) {
        if (labelData == null || !labelData.isVisible()) {
            return;
        }
        graphics.setColor(labelData.getColor());
        Font font = labelData.getFont().getAwtFont();
        graphics.setFont(font);
        String text = labelData.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        if (normalizeHtml) {
            text = text.replaceAll("(?s)<style.*?</style>", "");
            text = text.replaceAll("<.*?>", "");
            text = text.replaceAll("\\s+", " ").trim();
        }
        LineMetrics lineMetrics = font.getLineMetrics(text, graphics.getFontRenderContext());
        int y = (int)((float)labelData.getPosition().y + lineMetrics.getAscent());
        double maxWidth = RendererBase.determineLabelDimensions(text, font, graphics.getFontRenderContext()).getWidth();
        for (String line : StringUtils.splitLinesAsList((String)text)) {
            double width = font.getStringBounds(line, graphics.getFontRenderContext()).getWidth();
            int offset = 0;
            switch (horizontalAlignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    offset = (int)(maxWidth - width);
                    break;
                }
                default: {
                    offset = (int)((maxWidth - width) / 2.0);
                }
            }
            graphics.drawString(line, labelData.getPosition().x + offset, y);
            y += (int)lineMetrics.getHeight();
        }
    }

    protected static Dimension determineLabelDimensions(String text, Font font, FontRenderContext fontRenderContext) {
        if (StringUtils.isEmpty((String)text)) {
            return new Dimension(0, 0);
        }
        double maxWidth = 0.0;
        double height = 0.0;
        double defaultLineHeight = new TextLayout("Line", font, fontRenderContext).getBounds().getHeight();
        for (String line : StringUtils.splitLinesAsList((String)text)) {
            if (line.isEmpty()) {
                height += defaultLineHeight;
                continue;
            }
            Rectangle2D bounds = new TextLayout(line, font, fontRenderContext).getBounds();
            maxWidth = Math.max(maxWidth, bounds.getWidth());
            height += bounds.getHeight();
        }
        return new Dimension((int)maxWidth, (int)height);
    }
}

