/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkSampleTimeUtils {
    public static String getInheritedSampleTime(SimulinkBlock block) {
        return SimulinkSampleTimeUtils.getInheritedSampleTime(block, new HashSet<SimulinkBlock>());
    }

    private static String getInheritedSampleTime(SimulinkBlock block, Set<SimulinkBlock> visitedBlocks) {
        if (block == null || visitedBlocks.contains(block)) {
            return "";
        }
        visitedBlocks.add(block);
        if (block.isOfType("SubSystem")) {
            return SimulinkSampleTimeUtils.getInheritedSampleTimeFromSubsystem(block);
        }
        String sampleTime = block.getParameter("SampleTime");
        if (sampleTime == null) {
            sampleTime = block.getParameter("OutPortSampleTime");
        }
        if (!NumberUtils.isCreatable((String)sampleTime)) {
            return "";
        }
        if (!"-1".equals(sampleTime)) {
            return sampleTime;
        }
        return SimulinkSampleTimeUtils.getInheritedSampleTimeFromInports(block, visitedBlocks);
    }

    private static String getInheritedSampleTimeFromSubsystem(SimulinkBlock subSystem) {
        ArrayList<BigDecimal> sampleTimes = new ArrayList<BigDecimal>();
        for (SimulinkBlock subBlock : subSystem.getSubBlocks()) {
            String sampleTime;
            if (!subBlock.isOfType("Outport") || (sampleTime = SimulinkSampleTimeUtils.getInheritedSampleTime(subBlock)) == null || sampleTime.isEmpty()) continue;
            sampleTimes.add(new BigDecimal(sampleTime));
        }
        return SimulinkSampleTimeUtils.deduceSampleTime(sampleTimes);
    }

    private static String getInheritedSampleTimeFromInports(SimulinkBlock block, Set<SimulinkBlock> visitedBlocks) {
        UnmodifiableCollection<SimulinkInPort> inPorts = block.getInPorts();
        if (inPorts.isEmpty()) {
            if (block.isOfType("Inport") && block.getParent().isOfType("SubSystem")) {
                return SimulinkSampleTimeUtils.getInheritedSampleTime(SimulinkUtils.getConnectedBlock(SimulinkUtils.getInportFromSubsystemInportBlock(block)));
            }
            return "";
        }
        ArrayList<BigDecimal> inheritedSampleTimes = new ArrayList<BigDecimal>();
        for (SimulinkInPort inPort : inPorts) {
            String inheritedSampleTime = SimulinkSampleTimeUtils.getInheritedSampleTime(SimulinkUtils.getConnectedBlock(inPort), visitedBlocks);
            if (inheritedSampleTime.isEmpty()) continue;
            inheritedSampleTimes.add(new BigDecimal(inheritedSampleTime));
        }
        return SimulinkSampleTimeUtils.deduceSampleTime(inheritedSampleTimes);
    }

    private static String deduceSampleTime(List<BigDecimal> sampleTimes) {
        if (sampleTimes.isEmpty()) {
            return "";
        }
        if ((sampleTimes = sampleTimes.stream().distinct().collect(Collectors.toList())).size() == 1) {
            return sampleTimes.get(0).toString();
        }
        Collections.sort(sampleTimes);
        for (int i = 1; i < sampleTimes.size(); ++i) {
            if (sampleTimes.get(i).remainder(sampleTimes.get(0)).doubleValue() == 0.0) continue;
            return "";
        }
        return sampleTimes.get(0).toString();
    }

    private SimulinkSampleTimeUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

