/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util.geometry;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Optional;

public class PathIntersectionCalculator {
    public static Optional<Point2D.Double> intersection(GeneralPath a, GeneralPath b) {
        double currentX = 0.0;
        double currentY = 0.0;
        PathIterator intersectionPathIterator = a.getPathIterator(null);
        double[] coords = new double[6];
        while (!intersectionPathIterator.isDone()) {
            int type = intersectionPathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    Optional<Point2D.Double> intersection = PathIntersectionCalculator.computeIntersection(b, new Line2D.Double(currentX, currentY, coords[0], coords[1]));
                    if (!intersection.isPresent()) break;
                    return intersection;
                }
                case 2: 
                case 3: {
                    throw new IllegalArgumentException("Found a quad or cubic bezier segment in argument path");
                }
                case 4: {
                    throw new IllegalArgumentException("The given path is closed (i.e., an area, not a path)");
                }
            }
            currentX = coords[0];
            currentY = coords[1];
            intersectionPathIterator.next();
        }
        return Optional.empty();
    }

    private static Optional<Point2D.Double> computeIntersection(GeneralPath path, Line2D.Double line) {
        PathIterator intersectionPathIterator = path.getPathIterator(null);
        double currentX = 0.0;
        double currentY = 0.0;
        double[] coords = new double[6];
        while (!intersectionPathIterator.isDone()) {
            int type = intersectionPathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 1: {
                    Line2D.Double currentSegment = new Line2D.Double(currentX, currentY, coords[0], coords[1]);
                    if (line.intersectsLine(currentSegment)) {
                        return PathIntersectionCalculator.intersection(line, currentSegment);
                    }
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 2: 
                case 3: {
                    throw new IllegalArgumentException("Found a quad or cubic bezier segment in argument path");
                }
                case 4: {
                    throw new IllegalArgumentException("The given path is closed (i.e., an area, not a path)");
                }
            }
            intersectionPathIterator.next();
        }
        return Optional.empty();
    }

    public static Optional<Point2D.Double> intersection(Line2D.Double lineA, Line2D.Double lineB) {
        Point2D.Double pointA1 = (Point2D.Double)lineA.getP1();
        Point2D.Double pointA2 = (Point2D.Double)lineA.getP2();
        Point2D.Double pointB1 = (Point2D.Double)lineB.getP1();
        Point2D.Double pointB2 = (Point2D.Double)lineB.getP2();
        double x1 = pointA1.getX();
        double y1 = pointA1.getY();
        double x2 = pointA2.getX();
        double y2 = pointA2.getY();
        double x3 = pointB1.getX();
        double y3 = pointB1.getY();
        double x4 = pointB2.getX();
        double y4 = pointB2.getY();
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return Optional.empty();
        }
        double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
        double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
        return Optional.of(new Point2D.Double(xi, yi));
    }

    public static boolean hasIntersection(GeneralPath path, Rectangle rectangle) {
        PathIterator intersectionPathIterator = path.getPathIterator(null);
        double currentX = 0.0;
        double currentY = 0.0;
        double[] coords = new double[6];
        while (!intersectionPathIterator.isDone()) {
            int type = intersectionPathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 1: {
                    if (rectangle.intersectsLine(currentX, currentY, coords[0], coords[1])) {
                        return true;
                    }
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 2: 
                case 3: {
                    throw new IllegalArgumentException("Found a quad or cubic bezier segment in argument path");
                }
                case 4: {
                    throw new IllegalArgumentException("The given path is closed (i.e., an area, not a path)");
                }
            }
            intersectionPathIterator.next();
        }
        return false;
    }
}

