/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;

public class TypeScriptImportStatement {
    public final String fromType;
    public final String importName;
    public final boolean isTypeOnlyImport;

    public TypeScriptImportStatement(String fromFile, String importName, boolean isTypeOnlyImport) {
        this.fromType = fromFile;
        this.importName = importName;
        this.isTypeOnlyImport = isTypeOnlyImport;
    }

    public TypeScriptImportStatement(String fromFile, boolean isTypeOnlyImport) {
        this(fromFile, StringUtils.getLastPart((String)fromFile, (char)'/'), isTypeOnlyImport);
    }

    public String toCode() {
        String typeOrEmpty = this.isTypeOnlyImport ? "type" : "";
        return "import " + typeOrEmpty + " { " + this.importName + " } from '" + this.fromType + "';\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptImportStatement that = (TypeScriptImportStatement)o;
        return this.isTypeOnlyImport == that.isTypeOnlyImport && Objects.equals(this.fromType, that.fromType) && Objects.equals(this.importName, that.importName);
    }

    public int hashCode() {
        return Objects.hash(this.fromType, this.importName, this.isTypeOnlyImport);
    }
}

