/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.jsbuild.export.ExportTypeException;
import com.teamscale.jsbuild.export.TypescriptType;
import com.teamscale.jsbuild.module.EnumJavaScriptGenerationUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.jspecify.annotations.Nullable;

abstract class TypescriptTypeExporterBase {
    TypescriptTypeExporterBase() {
    }

    public abstract Optional<TypescriptType> resolveJavaScriptType(Class<?> var1, AnnotatedType var2, Member var3) throws ExportTypeException;

    protected static boolean hasGenericArguments(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    protected static boolean hasGenericArguments(ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments().length > 0;
    }

    protected static boolean isNullable(Field field) {
        return !field.getType().isPrimitive() && field.getAnnotatedType().isAnnotationPresent(Nullable.class);
    }

    protected static boolean isNullable(AnnotatedType annotatedType) {
        return annotatedType.isAnnotationPresent(Nullable.class);
    }

    protected static TypescriptType arrayWithType(TypescriptType typeName, boolean isNullable) {
        return new TypescriptType("Array<" + typeName.toNullableType() + ">", isNullable);
    }

    protected static TypescriptType mapWithTypes(TypescriptType keyType, TypescriptType valueType, boolean isNullable) {
        boolean isEnumKey;
        boolean bl = isEnumKey = keyType.toNullableType().startsWith("E") && keyType.toNullableType().endsWith("Entry");
        if (isEnumKey) {
            return new TypescriptType("Partial<Record<" + keyType.toNullableType() + ", " + valueType.toNullableType() + ">>", isNullable);
        }
        return new TypescriptType("Record<" + keyType.toNullableType() + ", " + valueType.toNullableType() + ">", isNullable);
    }

    protected static String createDataClassTypeName(Class<?> type) {
        return type.getSimpleName();
    }

    protected static TypescriptType createEnumClassType(Class<?> enumType, boolean isNullable) {
        if (!enumType.isAnnotationPresent(ExportToTypeScript.class)) {
            throw new ExportTypeException("Enum " + enumType.getSimpleName() + " is not marked with @" + ExportToTypeScript.class.getSimpleName());
        }
        return new TypescriptType(EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(TypescriptTypeExporterBase.createDataClassTypeName(enumType)), isNullable);
    }
}

