/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.anthropic.AnthropicClient;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="ai-engine.anthropic", name="Anthropic Provider", visibilityFeatureToggle=EFeatureToggle.AI_SUPPORT, type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AI, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class AnthropicEngineProviderOption
extends AiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="model")
    @OptionFieldDescription(name="The name of the Anthropic model to use, such as 'claude-3-7-sonnet'")
    public String model;
    @JsonProperty(value="apiKey")
    @PasswordOption
    @OptionFieldDescription(name="The API key to use for Anthropic.")
    public String apiKey;
    @JsonProperty(value="thinking")
    @OptionFieldDescription(name="Whether thinking mode is enabled.")
    public boolean thinking = false;

    @Override
    public String getInternalName() {
        return "anthropic." + this.model;
    }

    @Override
    public String getDisplayName() {
        return "Anthropic (" + this.model + ")";
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            Optional<String> modelDisplayName = new AnthropicClient(this.model, this.apiKey, false, 0.0, null).getModelDisplayName();
            if (modelDisplayName.isEmpty()) {
                return "Could not ensure model existence. Likely the model name is not valid.";
            }
        }
        catch (ServiceCallException e) {
            return e.getMessage();
        }
        return super.validate(storageInfo, instanceConfiguration);
    }

    @Override
    public Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> usageReporter) {
        return Optional.of(new AnthropicClient(this.model, this.apiKey, this.thinking, this.temperature, usageReporter));
    }
}

