/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="analysis-profiles", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class AnalysisProfileIndex
implements IGlobalIndex {
    private final ValueIndex<AnalysisProfile> delegateIndex;
    public static final String INDEX_NAME = "analysis-profiles";

    public AnalysisProfileIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public AnalysisProfile getProfile(String name) throws StorageException {
        return (AnalysisProfile)this.delegateIndex.getValue(name);
    }

    public List<AnalysisProfile> getProfiles(List<String> names, boolean forceExistence) throws StorageException {
        return this.delegateIndex.getValues(names, forceExistence);
    }

    public List<AnalysisProfile> getAllProfiles() throws StorageException {
        return this.delegateIndex.getAllEntries().getSecondList();
    }

    public void setProfile(AnalysisProfile analysisProfile) throws StorageException {
        this.delegateIndex.setValue(analysisProfile.getName(), (Object)analysisProfile);
    }

    public void deleteAfterHistoryHasBeenDeleted(String analysisProfileName) throws StorageException {
        this.delegateIndex.removeValue(analysisProfileName);
    }
}

