/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class MetricThresholdConfiguration
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="baseConfigurationName")
    private @Nullable String baseConfigurationName;
    private transient Optional<MetricThresholdConfiguration> baseConfiguration = Optional.empty();
    @JsonProperty(value="metricThresholdGroupList")
    private final List<MetricThresholdGroup> metricThresholdGroupList = new ArrayList<MetricThresholdGroup>();

    @JsonCreator
    public MetricThresholdConfiguration(@JsonProperty(value="name") String name) {
        super(name);
    }

    public MetricThresholdConfiguration(String name, MetricThresholdConfiguration baseConfiguration) {
        this(name);
        this.setBaseConfiguration(baseConfiguration);
    }

    public MetricThresholdConfiguration(String name, List<MetricThresholdGroup> groups) {
        this(name);
        this.metricThresholdGroupList.addAll(groups);
    }

    public String getBaseConfigurationName() {
        return this.baseConfigurationName;
    }

    public void setBaseConfigurationName(String baseConfigurationName) {
        this.baseConfigurationName = baseConfigurationName;
    }

    public void setBaseConfiguration(@Nullable MetricThresholdConfiguration baseConfiguration) {
        this.baseConfiguration = Optional.ofNullable(baseConfiguration);
        this.baseConfiguration.ifPresent(metricThresholdConfiguration -> {
            this.baseConfigurationName = metricThresholdConfiguration.getName();
        });
    }

    public Optional<MetricThresholdConfiguration> getBaseConfiguration() {
        if (this.baseConfiguration == null) {
            this.baseConfiguration = Optional.empty();
        }
        return this.baseConfiguration;
    }

    public boolean hasBaseConfiguration() {
        return !StringUtils.isEmpty((String)this.baseConfigurationName);
    }

    public MetricThresholdGroup addMetricThresholdGroup(String metricThresholdGroupName) {
        MetricThresholdGroup group = new MetricThresholdGroup(metricThresholdGroupName);
        this.metricThresholdGroupList.add(group);
        return group;
    }

    public void addMetricThresholdGroup(MetricThresholdGroup metricThresholdGroup) {
        this.metricThresholdGroupList.add(metricThresholdGroup);
    }

    public List<MetricThresholdGroup> getMetricThresholdGroupsOfThisConfiguration() {
        return this.metricThresholdGroupList;
    }

    public List<MetricThresholdGroup> computeTransitiveMetricThresholdGroups() throws MetricThresholdConfigurationException {
        if (this.hasBaseConfiguration()) {
            List<MetricThresholdGroup> thresholdGroups = this.createMergedMetricThresholdGroups();
            MetricThresholdConfiguration.applyOrderHints(thresholdGroups);
            return thresholdGroups;
        }
        return CollectionUtils.asUnmodifiable(this.getMetricThresholdGroupsOfThisConfiguration());
    }

    public MetricThresholdConfiguration createEvaluatedConfigurationFromBaseConfigurations() throws MetricThresholdConfigurationException {
        if (!this.hasBaseConfiguration()) {
            return this;
        }
        this.verifyBaseConfigurationsLoaded();
        MetricThresholdConfiguration configuration = new MetricThresholdConfiguration(this.getName());
        configuration.setBaseConfiguration(this.getBaseConfiguration().get());
        configuration.metricThresholdGroupList.addAll(this.computeTransitiveMetricThresholdGroups());
        return configuration;
    }

    private List<MetricThresholdGroup> createMergedMetricThresholdGroups() throws MetricThresholdConfigurationException {
        LinkedHashMap<String, LinkedHashMap<String, MetricThreshold>> groupNameToThresholdNameMap = this.collectThresholdsInHierarchy();
        ArrayList<MetricThresholdGroup> result = new ArrayList<MetricThresholdGroup>();
        for (Map.Entry<String, LinkedHashMap<String, MetricThreshold>> entry : groupNameToThresholdNameMap.entrySet()) {
            MetricThresholdGroup group = new MetricThresholdGroup(entry.getKey());
            group.addMetricThresholds(entry.getValue().values());
            result.add(group);
        }
        return result;
    }

    private static void applyOrderHints(List<MetricThresholdGroup> metricThresholdGroups) {
        metricThresholdGroups.forEach(MetricThresholdGroup::reorderThresholdsBasedOnOrderHints);
    }

    private LinkedHashMap<String, LinkedHashMap<String, MetricThreshold>> collectThresholdsInHierarchy() throws MetricThresholdConfigurationException {
        LinkedHashMap<String, LinkedHashMap<String, MetricThreshold>> groupNameToThresholdNameMap = new LinkedHashMap<String, LinkedHashMap<String, MetricThreshold>>();
        List<MetricThresholdConfiguration> configurationHierarchy = this.getConfigurationHierarchy();
        Collections.reverse(configurationHierarchy);
        for (MetricThresholdConfiguration configuration : configurationHierarchy) {
            for (MetricThresholdGroup thresholdGroup : configuration.getMetricThresholdGroupsOfThisConfiguration()) {
                this.collectMetricThresholdsFromGroups(configuration, thresholdGroup, groupNameToThresholdNameMap);
            }
        }
        return groupNameToThresholdNameMap;
    }

    private void collectMetricThresholdsFromGroups(MetricThresholdConfiguration configuration, MetricThresholdGroup thresholdGroup, LinkedHashMap<String, LinkedHashMap<String, MetricThreshold>> groupNameToThresholdNameMap) {
        String groupName = thresholdGroup.getName();
        LinkedHashMap thresholdNameToThreshold = groupNameToThresholdNameMap.computeIfAbsent(groupName, name -> new LinkedHashMap());
        for (MetricThreshold threshold : thresholdGroup.getMetricThresholdList()) {
            String baseConfiguration = thresholdNameToThreshold.containsKey(threshold.getDisplayName()) ? ((MetricThreshold)thresholdNameToThreshold.get(threshold.getDisplayName())).getSpecifiedInBaseConfiguration() : null;
            thresholdNameToThreshold.put(threshold.getDisplayName(), threshold);
            if (configuration != this) {
                threshold.setInheritedFrom(configuration);
                continue;
            }
            if (baseConfiguration == null) continue;
            threshold.setInheritedButOverridden(baseConfiguration);
        }
    }

    private Optional<MetricThresholdConfiguration> getBaseConfigurationWithCycleCheck(Set<MetricThresholdConfiguration> alreadyVisitedConfigurations) throws MetricThresholdConfigurationException {
        if (this.getBaseConfiguration().isPresent()) {
            if (alreadyVisitedConfigurations.contains(this.getBaseConfiguration().get())) {
                throw new MetricThresholdConfigurationException("Loop detected: " + this.getBaseConfiguration().get().getName());
            }
            alreadyVisitedConfigurations.add(this.getBaseConfiguration().get());
        }
        return this.getBaseConfiguration();
    }

    protected List<MetricThresholdConfiguration> getConfigurationHierarchy() throws MetricThresholdConfigurationException {
        this.verifyBaseConfigurationsLoaded();
        ArrayList<MetricThresholdConfiguration> configurationHierarchy = new ArrayList<MetricThresholdConfiguration>();
        HashSet<MetricThresholdConfiguration> alreadyVisitedConfigurations = new HashSet<MetricThresholdConfiguration>();
        Optional<MetricThresholdConfiguration> currentConfiguration = Optional.of(this);
        while (currentConfiguration.isPresent()) {
            configurationHierarchy.add(currentConfiguration.get());
            currentConfiguration = currentConfiguration.get().getBaseConfigurationWithCycleCheck(alreadyVisitedConfigurations);
        }
        return configurationHierarchy;
    }

    public Optional<MetricThreshold> findThreshold(String thresholdGroupName, String thresholdDisplayName) throws MetricThresholdConfigurationException {
        this.verifyBaseConfigurationsLoaded();
        return this.findThreshold(thresholdGroupName, thresholdDisplayName, new HashSet<MetricThresholdConfiguration>());
    }

    private Optional<MetricThreshold> findThreshold(String thresholdGroupName, String thresholdDisplayName, Set<MetricThresholdConfiguration> alreadyVisited) throws MetricThresholdConfigurationException {
        Optional<MetricThreshold> threshold = this.findThresholdInThisConfiguration(thresholdGroupName, thresholdDisplayName);
        if (!threshold.isPresent() && this.getBaseConfiguration().isPresent()) {
            return this.getBaseConfigurationWithCycleCheck(alreadyVisited).get().findThreshold(thresholdGroupName, thresholdDisplayName, alreadyVisited);
        }
        return threshold;
    }

    private Optional<MetricThresholdGroup> findGroupInThisConfiguration(String groupName) {
        CCSMAssert.isNotNull((Object)groupName);
        return this.metricThresholdGroupList.stream().filter(group -> group.getName().equals(groupName)).findFirst();
    }

    protected Optional<MetricThreshold> findThresholdInThisConfiguration(String thresholdGroupName, String thresholdDisplayName) {
        Optional<MetricThresholdGroup> metricThresholdGroup = this.findGroupInThisConfiguration(thresholdGroupName);
        if (metricThresholdGroup.isPresent()) {
            return metricThresholdGroup.get().findThresholdByDisplayName(thresholdDisplayName);
        }
        return Optional.empty();
    }

    public void adjustAndValidateData() throws MetricThresholdConfigurationException {
        this.adjustData();
        this.validateData();
    }

    protected void adjustData() {
        for (MetricThresholdGroup metricThresholdGroup : this.metricThresholdGroupList) {
            metricThresholdGroup.adjustValues();
        }
    }

    protected void validateData() throws MetricThresholdConfigurationException {
        this.checkForCycle();
        for (MetricThresholdGroup metricThresholdGroup : this.metricThresholdGroupList) {
            metricThresholdGroup.validate();
        }
    }

    protected void checkForCycle() throws MetricThresholdConfigurationException {
        this.verifyBaseConfigurationsLoaded();
        HashSet<MetricThresholdConfiguration> alreadyVisited = new HashSet<MetricThresholdConfiguration>();
        alreadyVisited.add(this);
        Optional<MetricThresholdConfiguration> inheritedConfiguration = this.getBaseConfigurationWithCycleCheck(alreadyVisited);
        while (inheritedConfiguration.isPresent()) {
            inheritedConfiguration = inheritedConfiguration.get().getBaseConfigurationWithCycleCheck(alreadyVisited);
        }
    }

    protected void verifyBaseConfigurationsLoaded() throws MetricThresholdConfigurationException {
        this.verifyBaseConfigurationsLoaded(new HashSet<MetricThresholdConfiguration>());
    }

    private void verifyBaseConfigurationsLoaded(Set<MetricThresholdConfiguration> alreadyVisited) throws MetricThresholdConfigurationException {
        if (!this.hasBaseConfiguration()) {
            return;
        }
        if (!this.getBaseConfiguration().isPresent()) {
            throw new MetricThresholdConfigurationException("Base configuration specified but not loaded");
        }
        this.getBaseConfigurationWithCycleCheck(alreadyVisited).get().verifyBaseConfigurationsLoaded(alreadyVisited);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetricThresholdConfiguration) {
            MetricThresholdConfiguration otherConfiguration = (MetricThresholdConfiguration)obj;
            return this.getName().equals(otherConfiguration.getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return "MetricThresholdConfiguration [name=" + this.getName() + ", baseConfiguration=" + String.valueOf(this.getBaseConfiguration().orElse(null)) + "]";
    }
}

