/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.index.IndexLayer;
import java.util.Optional;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class ConfigurationInitializationContext {
    private final @Nullable String username;
    private final IndexLayer indexLayer;
    private final IExternalCredentialsProvider externalCredentialsProvider;
    private final EInitializationReason reason;

    public ConfigurationInitializationContext(IndexLayer indexLayer, IExternalCredentialsProvider externalCredentialsProvider) {
        this(null, indexLayer, externalCredentialsProvider, EInitializationReason.OTHER);
    }

    public ConfigurationInitializationContext(@Nullable String username, IndexLayer indexLayer, IExternalCredentialsProvider externalCredentialsProvider, EInitializationReason reason) {
        this.username = username;
        this.indexLayer = indexLayer;
        this.externalCredentialsProvider = externalCredentialsProvider;
        this.reason = reason;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public GlobalStorageSystem getGlobalStorageSystem() throws StorageException {
        return this.indexLayer.openGlobalStorageSystem();
    }

    public IExternalCredentialsProvider getExternalCredentialsProvider() {
        return this.externalCredentialsProvider;
    }

    public EInitializationReason getReason() {
        return this.reason;
    }

    public IndexLayer getIndexLayer() {
        return this.indexLayer;
    }

    public static enum EInitializationReason {
        PROJECT_CREATION,
        PROJECT_REANALYSIS,
        BACKUP,
        OTHER;

    }
}

