/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ExternalToolCheckOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.JsonOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.NumberOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringListOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringOptionDescriptor;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ToolConfigurationBase
extends AnalysisConfigurationBase {
    protected final EAnalysisTool tool;
    private final String categoryName;
    private final String analysisGroupSuffix;
    protected final CodeScopeAware<Map<String, FindingDescriptor>> findingDescriptorsByFindingGroup = CodeScopeAware.defaultCodeScopeWithValue(new HashMap());
    private final CodeScopeAware<ListMap<String, FindingDescriptor>> findingDescriptorsByAnalysisGroup = CodeScopeAware.defaultCodeScopeWithValue(new ListMap());
    private final CodeScopeAware<Map<String, String>> groupToQualityIndicator = CodeScopeAware.defaultCodeScopeWithValue(new HashMap());
    protected final CodeScopeAware<Map<String, Object>> valueByOptionsId = CodeScopeAware.defaultCodeScopeWithValue(new HashMap());
    private @Nullable String descriptionsPath = null;
    private @Nullable Map<String, CheckMapping> checkNameToCheckMapping = null;
    private @Nullable Multimap<String, ToolCheckOption> checkIdToOption = null;
    private boolean isCodeScopeAware = false;

    protected ToolConfigurationBase(EAnalysisTool tool, String categoryName, @Nullable String analysisGroupSuffix) {
        this.tool = tool;
        this.categoryName = categoryName;
        this.analysisGroupSuffix = StringUtils.isEmpty((String)analysisGroupSuffix) ? "" : " (" + analysisGroupSuffix + ")";
    }

    protected ToolConfigurationBase(EAnalysisTool tool, String categoryName) {
        this(tool, categoryName, null);
    }

    protected ToolConfigurationBase(EAnalysisTool tool, String categoryName, @Nullable String descriptionsPath, String mappingFilePath, @Nullable String analysisGroupSuffix) throws ProjectConfigurationException {
        this(tool, categoryName, descriptionsPath, mappingFilePath, null, analysisGroupSuffix);
    }

    protected ToolConfigurationBase(EAnalysisTool tool, String categoryName, @Nullable String descriptionsPath, @NonNull String mappingFilePath, @Nullable String optionsFilePath, @Nullable String analysisGroupSuffix) throws ProjectConfigurationException {
        this.tool = tool;
        this.categoryName = categoryName;
        this.analysisGroupSuffix = StringUtils.isEmpty((String)analysisGroupSuffix) ? "" : " (" + analysisGroupSuffix + ")";
        this.descriptionsPath = descriptionsPath;
        Resource mappingsFile = Resource.of(this.getClass(), (String)mappingFilePath);
        this.checkNameToCheckMapping = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
        this.checkIdToOption = this.readOptions(optionsFilePath);
    }

    public EAnalysisTool getTool() {
        return this.tool;
    }

    protected void registerFinding(FindingDescriptor finding, String analysisGroupName, String findingsGroupName, CodeScopeName codeScopeName) {
        this.addFindingDescriptor(finding, codeScopeName);
        if (!this.findingDescriptorsByFindingGroup.contains(codeScopeName)) {
            this.findingDescriptorsByFindingGroup.setValue(codeScopeName, new HashMap());
        }
        this.findingDescriptorsByFindingGroup.getValue(codeScopeName).put(findingsGroupName, finding);
        if (!this.findingDescriptorsByAnalysisGroup.contains(codeScopeName)) {
            this.findingDescriptorsByAnalysisGroup.setValue(codeScopeName, (ListMap<String, FindingDescriptor>)new ListMap());
        }
        this.findingDescriptorsByAnalysisGroup.getValue(codeScopeName).add((Object)analysisGroupName, (Object)finding);
    }

    protected String getGroup(String groupName) {
        return groupName + this.analysisGroupSuffix;
    }

    public Map<String, String> getGroupToQualityIndicator(CodeScopeName codeScopeName) {
        return this.groupToQualityIndicator.getValue(codeScopeName);
    }

    protected Map<String, String> getOrInitGroupToQualityIndicator(CodeScopeName codeScopeName) {
        return this.groupToQualityIndicator.getOrComputeValue(codeScopeName, codeScope -> new HashMap());
    }

    public Map<String, FindingDescriptor> getFindingDescriptorsByFindingGroup(CodeScopeName codeScopeName) {
        return this.findingDescriptorsByFindingGroup.getValue(codeScopeName);
    }

    public ListMap<String, FindingDescriptor> getFindingDescriptorsByAnalysisGroup(CodeScopeName codeScopeName) {
        return this.findingDescriptorsByAnalysisGroup.getValue(codeScopeName);
    }

    @Override
    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        for (CodeScope codeScope : proxy.getCodeScopes()) {
            if (!this.findingDescriptorsByFindingGroup.contains(codeScope.getName())) continue;
            for (Map.Entry<String, FindingDescriptor> entry : this.findingDescriptorsByFindingGroup.getValue(codeScope.getName()).entrySet()) {
                proxy.addFindingsSchemaEntry(this.categoryName, entry.getKey(), entry.getValue(), codeScope.getName());
            }
        }
    }

    public void validateTools() throws ProjectConfigurationException {
    }

    @Override
    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains((Object)this.tool)) {
            return;
        }
        CodeScopeName codeScopeName = template.getCodeScope();
        if (this.checkNameToCheckMapping != null) {
            this.processMappingsAndDescription(codeScopeName);
        }
        if (!this.findingDescriptorsByFindingGroup.contains(codeScopeName)) {
            CCSMAssert.isTrue((!this.isCodeScopeAware ? 1 : 0) != 0, (String)"Code scope aware tool configurations need to register FindingDescriptors for each code scope.");
        }
        for (String group : this.findingDescriptorsByAnalysisGroup.getValueWithDefault(codeScopeName).getKeys()) {
            List<ConfigurationItemBase> configurationItems = this.determineConfigurationItems(languages, group, codeScopeName);
            if (configurationItems.isEmpty()) continue;
            String indicator = this.determineQualityIndicator(StringUtils.stripSuffix((String)group, (String)this.analysisGroupSuffix), codeScopeName);
            if (this.isCodeScopeAware) {
                template.registerConfigurationItemsCodeScopeAware(group, indicator, configurationItems);
                continue;
            }
            template.registerConfigurationItems(group, indicator, configurationItems);
        }
    }

    private List<ConfigurationItemBase> determineConfigurationItems(Set<ELanguage> languages, String group, CodeScopeName codeScopeName) {
        ArrayList<ConfigurationItemBase> configurationItems = new ArrayList<ConfigurationItemBase>();
        for (FindingDescriptor findingDescriptor : Objects.requireNonNull((List)this.findingDescriptorsByAnalysisGroup.getValueWithDefault(codeScopeName).getCollection((Object)group))) {
            if (!ToolConfigurationBase.findingShouldBeIncluded(languages, findingDescriptor)) continue;
            configurationItems.add(findingDescriptor);
            configurationItems.addAll((Collection<ConfigurationItemBase>)findingDescriptor.getReferencedOptions());
        }
        return configurationItems;
    }

    private static boolean findingShouldBeIncluded(Set<ELanguage> languages, FindingDescriptor findingDescriptor) {
        return !CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{findingDescriptor.getLanguages()}).isEmpty();
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        String qualityIndicatorName = this.groupToQualityIndicator.getValueWithDefault(codeScopeName).get(groupName);
        if (qualityIndicatorName != null) {
            return qualityIndicatorName;
        }
        return "Comprehensibility";
    }

    protected List<String> getActiveFindingGroupNames(CodeScopeName codeScopeName) {
        if (!this.findingDescriptorsByFindingGroup.contains(codeScopeName)) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        this.findingDescriptorsByFindingGroup.getValue(codeScopeName).forEach((findingGroupName, finding) -> {
            if (finding.isActive()) {
                names.add((String)findingGroupName);
            }
        });
        return names;
    }

    protected Set<String> getActiveFindingGroupNamesForAllCodeScopes() {
        HashSet<String> activeFindingGroupNames = new HashSet<String>();
        for (CodeScopeName codeScopeName : this.findingDescriptorsByFindingGroup.getCodeScopeNames()) {
            activeFindingGroupNames.addAll(this.getActiveFindingGroupNames(codeScopeName));
        }
        return activeFindingGroupNames;
    }

    public void processMappingsAndDescription(CodeScopeName codeScopeName) throws ProjectConfigurationException {
        SetMap checkNameAndLanguagesToId = new SetMap();
        CCSMAssert.isNotNull(this.checkNameToCheckMapping);
        for (Map.Entry<String, CheckMapping> mappingEntry : this.checkNameToCheckMapping.entrySet()) {
            checkNameAndLanguagesToId.add((Object)(mappingEntry.getValue().getReadableCheckName() + String.valueOf(this.determineLanguages(mappingEntry.getValue().checkId))), (Object)mappingEntry.getValue().checkId);
        }
        for (Map.Entry<String, CheckMapping> mappingEntry : this.checkNameToCheckMapping.entrySet()) {
            String rule = mappingEntry.getKey();
            CheckMapping mapping = this.checkNameToCheckMapping.get(rule);
            if (mapping.defaultEnablement == null) continue;
            if (!this.groupToQualityIndicator.contains(codeScopeName)) {
                this.groupToQualityIndicator.setValue(codeScopeName, new HashMap());
            }
            CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping((String)mapping.group, (String)mapping.category, this.groupToQualityIndicator.getValue(codeScopeName));
            this.groupToQualityIndicator.getValue(codeScopeName).put(mapping.group, mapping.category);
            String readableCheckName = mapping.getReadableCheckName();
            if (((Set)checkNameAndLanguagesToId.getCollectionOrEmpty((Object)(readableCheckName + String.valueOf(this.determineLanguages(mappingEntry.getValue().checkId))))).size() > 1) {
                readableCheckName = this.disambiguateCheckReadableName(readableCheckName, mapping.checkId);
            }
            this.createFindingType(mapping.checkId, readableCheckName, this.getDescription(rule, this.descriptionsPath), mapping.group, mapping.defaultEnablement, mapping.autoAllowed, Objects.requireNonNull(this.checkIdToOption).get((Object)mapping.checkId), codeScopeName);
        }
    }

    protected String disambiguateCheckReadableName(String readableCheckName, String checkId) {
        return readableCheckName + " \\(" + checkId + "\\)";
    }

    protected Multimap<String, ToolCheckOption> readOptions(String optionsFilePath) {
        ArrayListMultimap optionsMap = ArrayListMultimap.create();
        if (optionsFilePath != null) {
            Resource optionsFile = Resource.of(this.getClass(), (String)optionsFilePath);
            optionsMap = CheckMappingAndCheckOptionTSVUtils.readCheckOptionsFromTsvByFullID((Resource)optionsFile);
        }
        return optionsMap;
    }

    protected void createFindingType(String ruleId, String readableCheckName, String description, String group, EFindingEnablement defaultEnablement, boolean autoAllowed, Collection<ToolCheckOption> options, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        this.createFindingType(ruleId, readableCheckName, description, group, defaultEnablement, autoAllowed, this.determineLanguages(ruleId), options, codeScopeName);
    }

    private void createFindingType(String ruleId, String readableCheckName, String description, String group, EFindingEnablement defaultEnablement, boolean autoAllowed, Set<ELanguage> languages, Collection<ToolCheckOption> options, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        if (languages.isEmpty()) {
            return;
        }
        FindingDescriptor finding = new FindingDescriptor(ruleId, readableCheckName, this.tool, languages, defaultEnablement, description, autoAllowed);
        List<ConfigOptionDescriptorBase> checkOptions = this.loadCheckOptions(options, codeScopeName);
        for (ConfigOptionDescriptorBase checkOption : checkOptions) {
            finding.addReferencedOption(checkOption);
        }
        this.registerFinding(finding, group, ruleId, codeScopeName);
    }

    private List<ConfigOptionDescriptorBase> loadCheckOptions(Collection<ToolCheckOption> toolCheckOptions, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        if (!this.valueByOptionsId.contains(codeScopeName)) {
            this.valueByOptionsId.setValue(codeScopeName, new HashMap());
        }
        ArrayList<ConfigOptionDescriptorBase> checkOptions = new ArrayList<ConfigOptionDescriptorBase>();
        for (ToolCheckOption option : toolCheckOptions) {
            ExternalToolCheckOptionDescriptor descriptor = new ExternalToolCheckOptionDescriptor(this.valueByOptionsId.getValue(codeScopeName), option.fullQualifiedID, option.type);
            ConfigOptionDescriptorBase checkOption = switch (option.type) {
                default -> throw new MatchException(null, null);
                case EToolCheckOptionType.STRING -> new StringOptionDescriptor(option.getReadableName(), option.getDescription(), false, descriptor);
                case EToolCheckOptionType.MULTILINE_STRING -> new StringOptionDescriptor(option.getReadableName(), option.getDescription(), true, descriptor);
                case EToolCheckOptionType.BOOLEAN -> new BooleanOptionDescriptor(option.getReadableName(), option.getDescription(), descriptor);
                case EToolCheckOptionType.INTEGER -> new NumberOptionDescriptor<Integer>(option.getReadableName(), option.getDescription(), descriptor, Integer::valueOf);
                case EToolCheckOptionType.STRING_LIST -> new StringListOptionDescriptor(option.getReadableName(), option.getDescription(), true, descriptor);
                case EToolCheckOptionType.JSON -> new JsonOptionDescriptor(option.getReadableName(), option.getDescription(), descriptor);
            };
            checkOption.setValueAndDefaultValue(option.getDefaultValue(), codeScopeName);
            checkOptions.add(checkOption);
            this.addOption(checkOption);
        }
        return checkOptions;
    }

    protected String getDescription(String ruleId, @Nullable String descriptionPath) {
        CCSMAssert.isNotNull((Object)descriptionPath, (String)"The description path may not be null in the base case. If your tool does not need a description path, consider overriding ToolConfigurationBase#getDescription in your tool configuration.");
        CCSMAssert.isTrue((!descriptionPath.endsWith("/") ? 1 : 0) != 0, (String)"The path containing the descriptions must not end with a slash. We will append a slash and some JVMs won't find resource paths with two consecutive slashes.");
        Optional description = CheckDescriptionLoader.getCheckDescription(this.getClass(), (String)(descriptionPath + "/" + this.getDescriptionFileName(ruleId)));
        if (description.isEmpty()) {
            this.logMissingDescription(ruleId);
            return "";
        }
        return (String)description.get();
    }

    protected String getDescriptionFileName(String ruleId) {
        return ruleId + ".md";
    }

    private void logMissingDescription(String ruleId) {
        LogManager.getLogger().error("No description file found for rule {} from tool {}.", (Object)ruleId, (Object)this.tool.getReadableName());
    }

    protected Set<ELanguage> determineLanguages(String checkId) {
        return this.tool.getSupportedLanguages();
    }

    protected void declareCodeScopeAware() {
        this.isCodeScopeAware = true;
    }

    protected @Nullable CodeScopeAware<Collection<String>> getActiveCheckPerCodeScope(List<CodeScopeName> codeScopes) {
        CodeScopeAware<Collection<String>> selectedChecksPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : codeScopes) {
            selectedChecksPerCodeScope.setValue(codeScopeName, this.getActiveFindingGroupNames(codeScopeName));
        }
        if (selectedChecksPerCodeScope.getValues().stream().flatMap(Collection::stream).toList().isEmpty()) {
            return null;
        }
        return selectedChecksPerCodeScope;
    }
}

