/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import java.lang.reflect.Field;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NumericThresholdsOptionDescriptor
extends ConfigOptionDescriptorBase {
    public NumericThresholdsOptionDescriptor(ConfigExposed annotation, Field field) {
        super(annotation, field);
    }

    public NumericThresholdsOptionDescriptor(String name, String description, IConfigOptionDescriptorBehaviour behaviour) {
        super(name, description, false, behaviour);
    }

    @Override
    public String retrieveValueAsString(CodeScopeName codeScopeName) {
        return NumericThresholdsOptionDescriptor.getValueAsString(this.retrieveValue(codeScopeName));
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return JsonUtils.serializeToJSON((Object)this.defaultValue);
    }

    @Override
    protected Object parseValue(String optionValue) throws ProjectConfigurationException {
        try {
            NumericThresholds thresholds = (NumericThresholds)JsonUtils.deserializeFromJsonWithNullCheck((String)optionValue, NumericThresholds.class);
            if (thresholds.getYellowThreshold() >= thresholds.getRedThreshold()) {
                throw new ProjectConfigurationException("Error: lower threshold is higher than or equal to upper threshold for option " + this.getName());
            }
            return thresholds;
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException("Could not parse thresholds for option " + this.getName() + ": " + e.getMessage(), e);
        }
    }

    private static String getValueAsString(Object value) {
        return JsonUtils.serializeToJSON((Object)value);
    }

    @Override
    public @NonNull String normalizeValue(@Nullable String value) throws ProjectConfigurationException {
        return NumericThresholdsOptionDescriptor.getValueAsString(this.parseValue(value));
    }
}

