/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class PostRevisionCommitDescriptor
extends CommitDescriptor {
    private static final long serialVersionUID = 1L;
    private final List<CommitDescriptor> postRevisionTriggerHints;
    private final @Nullable String changeRetrieverToReschedule;
    private final boolean runPostBuildCompletenessTriggers;

    public PostRevisionCommitDescriptor() {
        super(CommitDescriptor.createUnbranchedDescriptor((long)0L));
        this.postRevisionTriggerHints = new ArrayList<CommitDescriptor>();
        this.changeRetrieverToReschedule = null;
        this.runPostBuildCompletenessTriggers = false;
    }

    public PostRevisionCommitDescriptor(List<CommitDescriptor> postRevisionTriggerHints, @Nullable String changeRetrieverToReschedule, boolean runPostBuildCompletenessTriggers) {
        super(CommitDescriptor.createUnbranchedDescriptor((long)0L));
        this.changeRetrieverToReschedule = changeRetrieverToReschedule;
        this.postRevisionTriggerHints = new ArrayList<CommitDescriptor>(postRevisionTriggerHints);
        this.runPostBuildCompletenessTriggers = runPostBuildCompletenessTriggers;
    }

    public UnmodifiableList<CommitDescriptor> getPostRevisionTriggerHints() {
        return CollectionUtils.asUnmodifiable(this.postRevisionTriggerHints);
    }

    public @Nullable String getChangeRetrieverToReschedule() {
        return this.changeRetrieverToReschedule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isReschedulePostRevisionTriggers(CommitDescriptor descriptor) {
        if (!(descriptor instanceof PostRevisionCommitDescriptor)) return false;
        PostRevisionCommitDescriptor postRevisionCommitDescriptor = (PostRevisionCommitDescriptor)descriptor;
        if (postRevisionCommitDescriptor.postRevisionTriggerHints.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSchedulePostBuildCompletenessTriggers(CommitDescriptor descriptor) {
        if (!(descriptor instanceof PostRevisionCommitDescriptor)) return false;
        PostRevisionCommitDescriptor postRevisionCommitDescriptor = (PostRevisionCommitDescriptor)descriptor;
        if (!postRevisionCommitDescriptor.runPostBuildCompletenessTriggers) return false;
        return true;
    }

    public static PostRevisionCommitDescriptor mergePostRevisionCommitDescriptors(PostRevisionCommitDescriptor commit1, PostRevisionCommitDescriptor commit2) {
        HashSet mergedPostRevisionTriggerHints = CollectionUtils.unionSet(commit1.getPostRevisionTriggerHints(), (Collection[])new Collection[]{commit2.getPostRevisionTriggerHints()});
        String changeRetrieverToReschedule = PostRevisionCommitDescriptor.getMergedChangeRetrieverToReschedule(commit1, commit2);
        return new PostRevisionCommitDescriptor(new ArrayList<CommitDescriptor>(mergedPostRevisionTriggerHints), changeRetrieverToReschedule, commit1.runPostBuildCompletenessTriggers || commit2.runPostBuildCompletenessTriggers);
    }

    private static @Nullable String getMergedChangeRetrieverToReschedule(PostRevisionCommitDescriptor commit1, PostRevisionCommitDescriptor commit2) {
        Preconditions.checkArgument((commit1.changeRetrieverToReschedule == null || commit2.changeRetrieverToReschedule == null || Objects.equals(commit1.changeRetrieverToReschedule, commit2.changeRetrieverToReschedule) ? 1 : 0) != 0, (Object)"Requested to reschedule two different change retrievers; this is currently not supported.");
        String changeRetrieverToReschedule = commit1.changeRetrieverToReschedule != null ? commit1.changeRetrieverToReschedule : commit2.changeRetrieverToReschedule;
        return changeRetrieverToReschedule;
    }
}

