/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.teamscale.AuthenticatorBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class ToolAuthenticatorBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticatorBase {
    private final Logger LOGGER = LogManager.getLogger();
    private final EAuthenticationTool authenticationTool;
    private final Class<ServerDescription> serverDescriptionClass;

    public ToolAuthenticatorBase(EAuthenticationTool tool, Class<ServerDescription> serverDescriptionClass) {
        this.authenticationTool = tool;
        this.serverDescriptionClass = serverDescriptionClass;
    }

    @Override
    public boolean authenticate(User user, byte[] password, String serverName, ServerOptionIndex optionIndex) throws StorageException {
        NamedServer<ServerDescription> server = ServerDescriptionBase.getServer(optionIndex, this.authenticationTool, this.serverDescriptionClass, serverName);
        if (server == null || ((ServerDescriptionBase)server.serverDescription()).isEmpty()) {
            this.LOGGER.error("No matching server found with name " + serverName);
            return false;
        }
        return this.authenticate(server, user, password, optionIndex);
    }

    @Override
    public List<String> getAllNames(ServerOptionIndex optionIndex) throws StorageException {
        String prefix = this.getAuthenticatorIdentifier() + ":";
        List<String> names = this.getServerNames(optionIndex);
        return CollectionUtils.map(names, name -> prefix + name);
    }

    private List<String> getServerNames(ServerOptionIndex optionIndex) throws StorageException {
        return AuthenticationToolUtils.getServerNames(this.authenticationTool, optionIndex);
    }

    @Override
    public String getDisplayName(String authentication) {
        return authentication;
    }

    protected abstract boolean authenticate(NamedServer<ServerDescription> var1, User var2, byte[] var3, ServerOptionIndex var4) throws StorageException;
}

