/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTree;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED}, valueClasses={CommitTree.class, EnumMap.class, ECommitTreeNodeState.class, Integer.class, Serializable.class})
public class CommitTreeIndex
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String EXTERNAL_ANALYSIS_INDEX_NAME = "external-analysis-commit-tree";
    public static final String BASE_NAME = "commit-tree";
    private static final byte[] COMMIT_TREE_KEY = Objects.requireNonNull(StringUtils.stringToBytes((String)"#-tree-#"));
    private static final byte[] STATUS_SUMMARY_KEY = Objects.requireNonNull(StringUtils.stringToBytes((String)"#-status-#"));
    private static final byte[] ADDITIONAL_DATA_PREFIX = Objects.requireNonNull(StringUtils.stringToBytes((String)"#-add-#"));

    public CommitTreeIndex(IStore store) {
        super(store);
    }

    public static String getIndexNameForRepository(String repositoryIdentifier) {
        return repositoryIdentifier + "-commit-tree";
    }

    public static PairList<String, ICommitTree> listCommitTrees(ProjectStorageSystem projectStorageSystem) throws StorageException {
        PairList trees = new PairList();
        IndexSchema schema = projectStorageSystem.getSchema();
        for (String storeName : schema.getEntryNames()) {
            Class<?> indexClass;
            try {
                indexClass = Class.forName(schema.getEntry(storeName).getIndexClass());
            }
            catch (ClassNotFoundException e) {
                LOGGER.fatal("Unable to load index class", (Throwable)e);
                continue;
            }
            if (!CommitTreeIndex.class.isAssignableFrom(indexClass)) continue;
            Class<CommitTreeIndex> subclass = indexClass.asSubclass(CommitTreeIndex.class);
            trees.add((Object)storeName, (Object)((CommitTreeIndex)projectStorageSystem.openProjectIndex(subclass, storeName, null)).loadTree());
        }
        return trees;
    }

    public CommitTree loadTree() throws StorageException {
        CommitTree commitTree = (CommitTree)StorageUtils.deserialize((byte[])this.store.get(COMMIT_TREE_KEY));
        if (commitTree == null) {
            commitTree = new CommitTree(this);
        } else {
            commitTree.initAfterDeserialization(this);
        }
        return commitTree;
    }

    public void storeTree(CommitTree commitTree) throws StorageException {
        this.store.put(COMMIT_TREE_KEY, StorageUtils.serialize((Serializable)commitTree));
        EnumMap stateCount = new EnumMap(ECommitTreeNodeState.class);
        commitTree.getAllRawNodes().forEach(node -> stateCount.merge(node.getState(), 1, Integer::sum));
        this.store.put(STATUS_SUMMARY_KEY, StorageUtils.serialize(stateCount));
    }

    public Map<ECommitTreeNodeState, Integer> getStateCount() throws StorageException {
        EnumMap stateCount = (EnumMap)StorageUtils.deserialize((byte[])this.store.get(STATUS_SUMMARY_KEY));
        if (stateCount == null) {
            return new EnumMap<ECommitTreeNodeState, Integer>(ECommitTreeNodeState.class);
        }
        return stateCount;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        CommitTree commitTree = this.loadTree();
        commitTree.performRollback(timestampByBranch);
        commitTree.persist();
    }

    public void storeAdditionalData(String key, Serializable value) throws StorageException {
        this.store.put(CommitTreeIndex.createAdditionalDataKey(key), StorageUtils.serialize((Serializable)value));
    }

    public Serializable getAdditionalData(String key) throws StorageException {
        return StorageUtils.deserialize((byte[])this.store.get(CommitTreeIndex.createAdditionalDataKey(key)));
    }

    private static byte[] createAdditionalDataKey(String key) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ADDITIONAL_DATA_PREFIX, StringUtils.stringToBytes((String)key)});
    }
}

