/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.config;

import com.teamscale.core.config.IDistributionLayerConfiguration;
import com.teamscale.core.config.LocalDistributionLayerConfiguration;
import java.util.Objects;
import java.util.Properties;
import org.conqat.engine.core.configuration.ConfigurationException;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class DistributionConfiguration {
    private static final String LAYER_KEY = "distribution.layer";
    private static final String DEFAULT_LAYER = EDistributionLayer.LOCAL.name();
    private final EDistributionLayer layer;
    private final IDistributionLayerConfiguration layerConfiguration;

    private DistributionConfiguration(EDistributionLayer layer, IDistributionLayerConfiguration layerConfiguration) {
        this.layer = Objects.requireNonNull(layer, "layer");
        this.layerConfiguration = Objects.requireNonNull(layerConfiguration, "layerConfiguration");
    }

    public static DistributionConfiguration readFromProperties(Properties properties) throws ConfigurationException {
        String layerName = properties.getProperty(LAYER_KEY, DEFAULT_LAYER);
        EDistributionLayer layer = (EDistributionLayer)EnumUtils.valueOfIgnoreCase(EDistributionLayer.class, (String)layerName);
        if (layer == null) {
            throw new ConfigurationException("Invalid layer type: " + layerName + ". Valid layer types are " + StringUtils.concat((Object[])EDistributionLayer.values(), (String)", ").toLowerCase());
        }
        return new DistributionConfiguration(layer, layer.readConfiguration(properties));
    }

    public EDistributionLayer getLayer() {
        return this.layer;
    }

    public IDistributionLayerConfiguration getLayerConfiguration() {
        return this.layerConfiguration;
    }

    public static enum EDistributionLayer {
        LOCAL{

            @Override
            IDistributionLayerConfiguration readConfiguration(Properties properties) {
                return new LocalDistributionLayerConfiguration();
            }
        };


        abstract IDistributionLayerConfiguration readConfiguration(Properties var1) throws ConfigurationException;
    }
}

