/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.custom;

import java.util.Map;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.TeamscaleCustomLogAppender;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;

@Index(name="custom-log-configuration")
public class CustomLogConfigurationIndex
implements IGlobalIndex {
    private final SimpleCrudIndex<String, ELogLevel> configDelegate;

    public CustomLogConfigurationIndex(IStore store) {
        this.configDelegate = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "config"), ISerializer.forString(), ISerializer.forEnumOrdinal(ELogLevel.class));
    }

    public Map<String, ELogLevel> getLoggers() throws StorageException {
        return this.configDelegate.getEntries().toMap();
    }

    public void setLogger(String name, ELogLevel level) throws StorageException {
        this.configDelegate.put((Object)name, (Object)level);
        this.replayConfiguration();
    }

    public void removeLogger(String name) throws StorageException {
        this.configDelegate.remove((Object)name);
        this.replayConfiguration();
    }

    public void replayConfiguration() throws StorageException {
        TeamscaleCustomLogAppender.updateLog4j(this.getLoggers());
    }
}

