/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.parse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.parse.EParseLogOrigin;
import java.io.Serializable;
import java.util.Comparator;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ParseLogEntry
implements Serializable,
Comparable<ParseLogEntry> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<ParseLogEntry> PARSE_LOG_COMPARATOR = Comparator.comparing(ParseLogEntry::getCommit).reversed().thenComparing(ParseLogEntry::getUniformPath).thenComparing(ParseLogEntry::getLineNumber);
    private static final String ORIGIN = "origin";
    private static final String MESSAGE = "message";
    private static final String UNIFORM_PATH = "uniformPath";
    private static final String COMMIT = "commit";
    private static final String LINE_NUMBER = "lineNumber";
    @JsonProperty(value="origin")
    private final EParseLogOrigin origin;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="commit")
    private final CommitDescriptor commit;
    @JsonProperty(value="lineNumber")
    private final int lineNumber;

    @JsonCreator
    public ParseLogEntry(@JsonProperty(value="origin") EParseLogOrigin origin, @JsonProperty(value="message") String message, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="lineNumber") int lineNumber) {
        this.origin = origin;
        this.message = message;
        this.uniformPath = uniformPath;
        this.commit = commit;
        this.lineNumber = lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(ParseLogEntry entry) {
        return PARSE_LOG_COMPARATOR.compare(this, entry);
    }
}

