/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public class MetricSchemaRetrieverFactory {
    private final Map<UniformPath.EType, IMetricSchemaRetriever> schemaRetriever;
    private final Map<String, IMetricSchemaRetriever> indexSchemaRetriever;
    private final ProjectStorageSystem projectStorageSystem;

    public MetricSchemaRetrieverFactory(@NonNull ProjectStorageSystem projectStorageSystem) {
        CCSMAssert.isNotNull((Object)projectStorageSystem);
        this.projectStorageSystem = projectStorageSystem;
        this.indexSchemaRetriever = new HashMap<String, IMetricSchemaRetriever>();
        this.schemaRetriever = new HashMap<UniformPath.EType, IMetricSchemaRetriever>();
        this.schemaRetriever.put(UniformPath.EType.CODE, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever("metric-schema", projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.ARCHITECTURE, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever("metric-schema", projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.CODE_SCOPES, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever("metric-schema", projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.TEST_EXECUTION, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever(MetricSchemaIndex.EMetricSchemaType.TEST_EXECUTION.getIndexName(), projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.SPEC_ITEM, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever(MetricSchemaIndex.EMetricSchemaType.WORK_ITEM.getIndexName(), projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.EXECUTION_UNIT, new IMetricSchemaRetriever.EmptySchemaRetriever());
        this.schemaRetriever.put(UniformPath.EType.NON_CODE, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever(MetricSchemaIndex.EMetricSchemaType.PROCESS.getIndexName(), projectStorageSystem));
        this.schemaRetriever.put(UniformPath.EType.TEST_IMPLEMENTATION, new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever(MetricSchemaIndex.EMetricSchemaType.TEST_EXECUTION.getIndexName(), projectStorageSystem));
    }

    public IMetricSchemaRetriever createForType(UniformPath.EType entityType) {
        IMetricSchemaRetriever result = this.schemaRetriever.get(entityType);
        CCSMAssert.isNotNull((Object)result, (String)String.format("No valid metric retriever for entity type %s", entityType));
        return result;
    }

    public IMetricSchemaRetriever createForType(String indexName) {
        IMetricSchemaRetriever result = this.indexSchemaRetriever.get(indexName);
        if (result == null) {
            result = new IMetricSchemaRetriever.IndexBasedMetricSchemaRetriever(indexName, this.projectStorageSystem);
            this.indexSchemaRetriever.put(indexName, result);
        }
        return result;
    }
}

