/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PermissionLookup<T> {
    @JsonProperty(value="instanceGlobalPermissions")
    private final Set<T> instanceGlobalPermissions;
    @JsonProperty(value="instanceSpecificPermissions")
    private final Map<String, Set<T>> instanceSpecificPermissions;

    PermissionLookup(Set<T> globalPermissions, Map<String, Set<T>> instanceSpecificPermissions) {
        this.instanceGlobalPermissions = globalPermissions;
        this.instanceSpecificPermissions = instanceSpecificPermissions;
    }

    public Set<T> getPermissions(String instanceId) {
        return CollectionUtils.unionSet(this.instanceGlobalPermissions, (Collection[])new Collection[]{(Collection)this.instanceSpecificPermissions.getOrDefault(instanceId, (Set<T>)CollectionUtils.emptySet())});
    }

    public Set<T> getPermissions(List<String> instanceIds) {
        Collection[] collectionArray = new Collection[1];
        collectionArray[0] = instanceIds.stream().map(this.instanceSpecificPermissions::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        return CollectionUtils.unionSet(this.instanceGlobalPermissions, (Collection[])collectionArray);
    }

    public boolean hasPermission(String instanceId, T permission) {
        return this.getPermissions(instanceId).contains(permission);
    }

    public boolean hasInstanceSpecificPermission(String instanceId, T permission) {
        return ((Set)this.getInstanceSpecificPermissions().getOrDefault(instanceId, (Set<T>)CollectionUtils.emptySet())).contains(permission);
    }

    Map<String, Set<T>> getInstanceSpecificPermissions() {
        return CollectionUtils.asUnmodifiable(this.instanceSpecificPermissions);
    }
}

