/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

public final class RoleSchemaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="globalRolesByName")
    private final Map<String, GlobalRole> globalRolesByName;
    @JsonProperty(value="projectRolesByName")
    private final Map<String, ProjectRole> projectRolesByName;

    public RoleSchemaData(Set<GlobalRole> globalRoles, Set<ProjectRole> projectRoles) {
        CCSMAssert.isNotEmpty(globalRoles, (String)"Parameter 'globalRoles' must not be empty");
        CCSMAssert.isNotEmpty(projectRoles, (String)"Parameter 'projectRoles' must not be empty");
        this.globalRolesByName = new HashMap<String, GlobalRole>();
        globalRoles.forEach(r -> this.globalRolesByName.put(r.getReadableName(), (GlobalRole)r));
        this.projectRolesByName = new HashMap<String, ProjectRole>();
        projectRoles.forEach(r -> this.projectRolesByName.put(r.getReadableName(), (ProjectRole)r));
    }

    public Map<String, GlobalRole> getGlobalRolesByName() {
        return this.globalRolesByName;
    }

    public Map<String, ProjectRole> getProjectRolesByName() {
        return this.projectRolesByName;
    }
}

