/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.performance;

import com.teamscale.commons.lang.IntSummaryStatisticsHolder;
import com.teamscale.commons.lang.LongSummaryStatisticsHolder;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import java.io.Serializable;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StoreOperationStatistics;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class PerformanceAggregateEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EAnalysisState state;
    private final String trigger;
    private long executionCount;
    private final IntSummaryStatisticsHolder triggerParallelism = new IntSummaryStatisticsHolder();
    private final LongSummaryStatisticsHolder triggerRuntimeMillis = new LongSummaryStatisticsHolder();
    private final LongSummaryStatisticsHolder aggregatedWallTimeMillis = new LongSummaryStatisticsHolder();
    private final LongSummaryStatisticsHolder maxMemoryBytes = new LongSummaryStatisticsHolder();
    private final LongSummaryStatisticsHolder storageCalls = new LongSummaryStatisticsHolder();
    private final LongSummaryStatisticsHolder storageTimeMillis = new LongSummaryStatisticsHolder();
    private final LinkedHashMap<String, LongSummaryStatisticsHolder> sectionTimeMillis = new LinkedHashMap();
    private Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> storageOperationStatistics;

    public PerformanceAggregateEntry(EAnalysisState state, String trigger) {
        this.state = state;
        this.trigger = trigger;
    }

    public void update(PerformanceDetailEntry entry) {
        ++this.executionCount;
        this.triggerRuntimeMillis.update(entry.getMainWorkerPerformance().duration().toMillis());
        Iterator iter = entry.getWorkerPerformance().iterator();
        while (iter.hasNext()) {
            PerformanceDetailEntry.WorkerPerformanceData next = (PerformanceDetailEntry.WorkerPerformanceData)iter.next();
            this.aggregatedWallTimeMillis.update(next.duration().toMillis());
            this.maxMemoryBytes.update(next.maxMemoryBytes());
        }
        this.triggerParallelism.update(entry.getParallelism());
        this.storageCalls.update(entry.getStorageCalls());
        this.storageTimeMillis.update(entry.getStorageTimeMillis());
        for (Map.Entry<String, Long> sectionEntry : entry.getSectionTimeMillis().entrySet()) {
            this.sectionTimeMillis.computeIfAbsent(sectionEntry.getKey(), key -> new LongSummaryStatisticsHolder()).update(sectionEntry.getValue().longValue());
        }
        this.mergeStorageOperationStatistics(entry.getStoreOperationStatisticsByStore());
    }

    private void mergeStorageOperationStatistics(Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> newStoreStatistics) {
        if (this.getStorageOperationStatistics() == null && newStoreStatistics != null) {
            this.storageOperationStatistics = newStoreStatistics;
        } else if (this.getStorageOperationStatistics() != null && newStoreStatistics != null) {
            this.aggregateStoreStatistics(newStoreStatistics);
        }
    }

    private void aggregateStoreStatistics(Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> newStoreStatistics) {
        for (Map.Entry<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> statisticEntry : newStoreStatistics.entrySet()) {
            this.getStorageOperationStatistics().merge(statisticEntry.getKey(), statisticEntry.getValue(), PerformanceAggregateEntry::mergeStoreStatistics);
        }
    }

    private static Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> mergeStoreStatistics(Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> oldValue, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> newValue) {
        for (Map.Entry<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> operationStatistic : newValue.entrySet()) {
            oldValue.merge(operationStatistic.getKey(), operationStatistic.getValue(), StoreOperationStatistics::aggregate);
        }
        return oldValue;
    }

    public static PerformanceAggregateEntry merge(PerformanceAggregateEntry entry1, PerformanceAggregateEntry entry2) {
        CCSMAssert.isTrue((entry1.getState() == entry2.getState() ? 1 : 0) != 0, (String)"States must match!");
        CCSMAssert.isTrue((boolean)entry1.getTrigger().equals(entry2.getTrigger()), (String)"Triggers must match!");
        PerformanceAggregateEntry result = new PerformanceAggregateEntry(entry1.getState(), entry1.getTrigger());
        result.merge(entry1);
        result.merge(entry2);
        return result;
    }

    private void merge(PerformanceAggregateEntry entry) {
        this.executionCount += entry.getExecutionCount();
        this.triggerRuntimeMillis.merge(entry.triggerRuntimeMillis);
        this.aggregatedWallTimeMillis.merge(entry.aggregatedWallTimeMillis);
        this.triggerParallelism.merge(entry.triggerParallelism);
        this.maxMemoryBytes.merge(entry.maxMemoryBytes);
        this.storageCalls.merge(entry.storageCalls);
        this.storageTimeMillis.merge(entry.storageTimeMillis);
        for (Map.Entry<String, LongSummaryStatistics> sectionEntry : this.getSectionTimeMillis()) {
            this.sectionTimeMillis.computeIfAbsent(sectionEntry.getKey(), key -> new LongSummaryStatisticsHolder()).merge(sectionEntry.getValue());
        }
        this.mergeStorageOperationStatistics(entry.getStorageOperationStatistics());
    }

    public EAnalysisState getState() {
        return this.state;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public LongSummaryStatistics getTriggerRuntimeMillis() {
        return this.triggerRuntimeMillis.getStatistics();
    }

    public LongSummaryStatistics getAggregatedWallTimeMillis() {
        return this.aggregatedWallTimeMillis.getStatistics();
    }

    public IntSummaryStatistics getTriggerParallelism() {
        return this.triggerParallelism.getStatistics();
    }

    public LongSummaryStatistics getMaxMemoryBytes() {
        return this.maxMemoryBytes.getStatistics();
    }

    public LongSummaryStatistics getStorageCalls() {
        return this.storageCalls.getStatistics();
    }

    public LongSummaryStatistics getStorageTimeMillis() {
        return this.storageTimeMillis.getStatistics();
    }

    public Iterable<Map.Entry<String, LongSummaryStatistics>> getSectionTimeMillis() {
        return () -> this.sectionTimeMillis.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((LongSummaryStatisticsHolder)e.getValue()).getStatistics())).iterator();
    }

    public Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> getStorageOperationStatistics() {
        return this.storageOperationStatistics;
    }
}

