/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.PairList;

@Index(name="trigger", options={EStorageOption.NO_ROLLBACK}, valueClassNames={"com.teamscale.index.check.CheckOptionStore"})
public class TriggerIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "trigger";
    private final ValueIndex<TriggerDescription> triggerDelegate;
    private final SimpleCrudIndex<EAnalysisState, HashSet<Class<? extends PostRevisionAnalysisTriggerBase>>> postRevisionTriggersDelegate;
    private final KeysOnlyIndex postBuildCompletenessTriggersDelegate;

    public TriggerIndex(IStore store) {
        this.triggerDelegate = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "trigger-descriptions"));
        this.postRevisionTriggersDelegate = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "post-revision-triggers"), ISerializer.forEnumOrdinal(EAnalysisState.class), ISerializer.forSerializable());
        this.postBuildCompletenessTriggersDelegate = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(store, "post-build-completeness-triggers"));
    }

    public HashSet<Class<? extends PostRevisionAnalysisTriggerBase>> getPostRevisionAnalysisTriggers(EAnalysisState analysisState) throws StorageException {
        return this.postRevisionTriggersDelegate.get((Object)analysisState).orElseGet(HashSet::new);
    }

    public Collection<String> getPostBuildCompletenessAnalysisTriggers() throws StorageException {
        return this.postBuildCompletenessTriggersDelegate.listKeys();
    }

    public void addPostRevisionAnalysisTrigger(EAnalysisState analysisState, Class<? extends PostRevisionAnalysisTriggerBase> postRevisionTriggerClass) throws StorageException {
        HashSet<Class<? extends PostRevisionAnalysisTriggerBase>> triggers = this.getPostRevisionAnalysisTriggers(analysisState);
        triggers.add(postRevisionTriggerClass);
        this.postRevisionTriggersDelegate.put((Object)analysisState, triggers);
    }

    public void addPostBuildCompletenessAnalysisTrigger(String postBuildCompletenessTriggerName) throws StorageException {
        this.postBuildCompletenessTriggersDelegate.storeKey(postBuildCompletenessTriggerName);
    }

    public void removeAllTriggers() throws StorageException {
        this.triggerDelegate.removeAllEntries();
    }

    public void setTriggers(PairList<String, TriggerDescription> triggerDescriptions) throws StorageException {
        this.triggerDelegate.setValues(triggerDescriptions);
    }

    public PairList<String, TriggerDescription> getAllTriggers() throws StorageException {
        return this.triggerDelegate.getAllEntries();
    }

    public List<String> getAllTriggerNames() throws StorageException {
        return this.triggerDelegate.getAllKeys();
    }

    public TriggerDescription getTrigger(String triggerName) throws StorageException {
        return (TriggerDescription)this.triggerDelegate.getValue(triggerName);
    }

    public List<TriggerDescription> getTriggers(List<String> triggerNames) throws StorageException {
        return this.triggerDelegate.getValues(triggerNames);
    }

    public void setTrigger(String triggerName, TriggerDescription triggerDescription) throws StorageException {
        this.triggerDelegate.setValue(triggerName, (Object)triggerDescription);
    }

    public void removeTrigger(String triggerName) throws StorageException {
        this.triggerDelegate.removeValue(triggerName);
    }
}

