/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.trigger;

import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

class TriggerTopSorter {
    private final List<AnalysisTrigger> compiledTriggers = new ArrayList<AnalysisTrigger>();
    private final IndexSchema projectSchema;
    private final SetMap<String, String> dependeesByTrigger = new SetMap();

    public TriggerTopSorter(List<AnalysisTrigger> compiledTriggers, IndexSchema projectSchema) {
        this.compiledTriggers.addAll(compiledTriggers);
        this.projectSchema = projectSchema;
    }

    public void calculateExecutionOrder() throws TriggerCompilationException {
        this.fillDependeesByTrigger();
        List<AnalysisTrigger> sortedTriggers = this.performTopSort();
        this.calculateExpectedOverallCostsAndFillTransitiveStores(sortedTriggers);
    }

    private void fillDependeesByTrigger() {
        SetMap writingTriggersByStore = new SetMap();
        for (AnalysisTrigger compiledTrigger : this.compiledTriggers) {
            for (String writeStore : compiledTrigger.getWriteStores()) {
                writingTriggersByStore.add((Object)writeStore, (Object)compiledTrigger.getName());
            }
        }
        for (AnalysisTrigger compiledTrigger : this.compiledTriggers) {
            for (String inputStore : compiledTrigger.getAllInputStoresForCurrentRevision()) {
                Set writers = (Set)writingTriggersByStore.getCollection((Object)inputStore);
                if (writers == null) continue;
                this.dependeesByTrigger.addAll((Object)compiledTrigger.getName(), (Collection)writers);
            }
        }
    }

    private List<AnalysisTrigger> performTopSort() throws TriggerCompilationException {
        IdentityHashSet triggersLeft = new IdentityHashSet(this.compiledTriggers);
        ArrayList<AnalysisTrigger> orderedTriggers = new ArrayList<AnalysisTrigger>();
        while (!triggersLeft.isEmpty()) {
            List<AnalysisTrigger> executableTriggers = this.findReadyTriggers((Set<AnalysisTrigger>)triggersLeft);
            if (executableTriggers.isEmpty()) {
                this.reportCycle((Set<AnalysisTrigger>)triggersLeft);
            }
            CollectionUtils.removeAll((Set)triggersLeft, executableTriggers);
            for (AnalysisTrigger trigger : executableTriggers) {
                orderedTriggers.add(trigger);
                for (String key : this.dependeesByTrigger.getKeys()) {
                    ((Set)this.dependeesByTrigger.getCollection((Object)key)).remove(trigger.getName());
                }
            }
        }
        return orderedTriggers;
    }

    private List<AnalysisTrigger> findReadyTriggers(Set<AnalysisTrigger> triggersLeft) {
        ArrayList<AnalysisTrigger> readyTriggers = new ArrayList<AnalysisTrigger>();
        for (AnalysisTrigger trigger : triggersLeft) {
            Set dependees = (Set)this.dependeesByTrigger.getCollection((Object)trigger.getName());
            if (!CollectionUtils.isNullOrEmpty((Collection)dependees)) continue;
            readyTriggers.add(trigger);
        }
        return readyTriggers;
    }

    private void reportCycle(Set<AnalysisTrigger> triggersLeft) throws TriggerCompilationException {
        ArrayList<String> triggerNames = new ArrayList<String>();
        String currentName = ((AnalysisTrigger)CollectionUtils.getAny(triggersLeft)).getName();
        while (!triggerNames.contains(currentName)) {
            triggerNames.add(currentName);
            currentName = (String)CollectionUtils.getAny((Iterable)this.dependeesByTrigger.getCollection((Object)currentName));
        }
        while (!((String)triggerNames.get(0)).equals(currentName)) {
            triggerNames.remove(0);
        }
        ArrayList triggersInCycle = new ArrayList();
        for (String name : triggerNames) {
            this.compiledTriggers.stream().filter(trigger -> trigger.getName().equals(name)).forEach(triggersInCycle::add);
        }
        HashSet<String> inputs = new HashSet<String>();
        HashSet<String> outputs = new HashSet<String>();
        for (AnalysisTrigger blockTrigger : triggersInCycle) {
            inputs.addAll(blockTrigger.getAllInputStoresForCurrentRevision());
            outputs.addAll((Collection<String>)blockTrigger.getWriteStores());
        }
        throw new TriggerCompilationException("Found a cycle in the trigger graph involving the following triggers: " + StringUtils.concat(triggersInCycle, (String)", ") + " Probably the following in/outputs are the problem: " + String.valueOf(CollectionUtils.intersectionSet(inputs, (Collection[])new Collection[]{outputs})));
    }

    private void calculateExpectedOverallCostsAndFillTransitiveStores(List<AnalysisTrigger> sortedTriggers) {
        ListMap triggersForDelta = new ListMap();
        for (AnalysisTrigger trigger : CollectionUtils.reverse(sortedTriggers)) {
            int cost = trigger.getExpectedCost().getCost();
            for (String writeStore : trigger.getWriteStores()) {
                if (!triggersForDelta.containsCollection((Object)writeStore)) continue;
                for (AnalysisTrigger activatedTrigger : (List)triggersForDelta.getCollection((Object)writeStore)) {
                    cost += activatedTrigger.getExpectedOverallCost();
                    trigger.addTransitiveWriteStores((Collection<String>)activatedTrigger.getTransitiveWriteStores());
                    trigger.addTransitiveWriteBlockingReadStores((Collection<String>)activatedTrigger.getTransitiveWriteBlockingReadStores());
                }
            }
            trigger.setExpectedOverallCost(cost);
            this.fillWriteBlockingStores(trigger);
            for (String deltaName : trigger.getExpectedDeltaStoreNames()) {
                triggersForDelta.add((Object)deltaName, (Object)trigger);
            }
        }
    }

    private void fillWriteBlockingStores(AnalysisTrigger trigger) {
        trigger.addTransitiveWriteStores((Collection<String>)trigger.getWriteStores());
        trigger.addTransitiveWriteBlockingReadStores((Collection<String>)trigger.getReadBranchingLayerStores());
        for (String store : trigger.getReadOnlyStores()) {
            if (this.isCommitIsolated(store)) continue;
            trigger.addTransitiveWriteBlockingReadStores(Collections.singleton(store));
        }
        for (String store : trigger.getWriteStores()) {
            if (this.isCommitIsolated(store)) continue;
            trigger.addCrossCommitWriteBlockingStore(store);
        }
    }

    private boolean isCommitIsolated(String store) throws AssertionError {
        SchemaEntry entry = this.projectSchema.getEntry(store);
        CCSMAssert.isNotNull((Object)entry, (String)"Entry should not be null here, as this was checked in earlier stages of the compiler!");
        return entry.usesOption(EStorageOption.BRANCHED) || entry.usesOption(EStorageOption.COMMIT_ISOLATED);
    }
}

